- SoftCumulative **extends** Cumulative **of Choco by maintaining over-loads variables at**
each point in time, and by pruning activities according to maximal available capacities given by upper bounds of these variables instead of simply considering max capa**. This** constraint can be used with various objective criteria.
- The SoftCumulativeSum **extends the** SoftCumulative**. It is defined to deal more**
efficiently with a particular criterion: minimize the sum of over-loads.

## 2.2.1 Softcumulative Constraint

Definition 6 Let A be a set of activities scheduled between time 0 and m*, each consuming a* positive amount of the resource. SoftCumulative *augments* Cumulative *with a second limit* of resource ideal capa ≤ max **capa***, and for each point in time* **t < m** *an integer variable* costV ar[t]*. It enforces:*
- *C1 and C2 (see* **Definition 2**).

- *C3: For each point in time* t, costV ar[t] = max(0, ht − ideal **capa**)

![0_image_0.png](0_image_0.png)

Example 2 *Figure 3 depicts an example of a cumulative profile* **CumP** where at each point in time t *the height of* **CumP** at t *does not exceed the maximum value in the domain of* its corresponding violation variable **costV ar**[t]. Time points 1, 2, 3 *are such that* **CumP** exceeds ideal **capa** *by two. Therefore, for each point, the minimum value of the domain of* the correspondong variable in **costV ar** *should be updated to value* 2.

Next paragraph details how the classical sweep procedure can be adapted to the SoftCumulative **constraint.**
Revised Sweep pruning procedure. The limit of resource is not max capa **as in the**
Cumulative **constraint. It is mandatory to take into account upper-bounds of variables in**
costV ar**. One may integrate reductions on upper bounds within the profile, as new fixed** activities. However, our discretization of time can be very costly with this method : the number of events may grow significantly. The profile would not be computed only from activities but also from each point in time.