# Modelling Concurrent Behaviors In The Process Specification Language

Dai Tri Man Lˆe Department of Computer Science, University of Toronto, Toronto, ON, M5S 3G4 Canada ledt@cs.toronto.edu Abstract. In this paper, we propose a first-order ontology for generalized stratified order structure. We then classify the models of the theory using modeltheoretic techniques. An ontology mapping from this ontology to the core theory of Process Specification Language is also discussed.

## 1 Introduction

In Process Specification Language (PSL), the ordering of event (activity) occurrences is modelled using occurrence trees, which are restricted forms of partial orders. Although partial orders can sufficiently model the "earlier than" relationship, they cannot *explicitly* model the "not later than" relationship [7]. For instance, if an event a is performed
"not later than" an event b, then this "not later than" relationship can be modelled by the following set of two step sequences x = {{a}{b},{a,b}}, where the *step* {a,b} models the simultaneous performance of a and b. But the set x can not be represented by any partial order.

To provide a unified framework for analyzing "earlier than" and "not later than" relationships, we proposed to interpret the generalized stratified order structure (*gsostructure*) theory within PSL. The gso-structure theory is originated from causal partial order theory and stratified order structure (*so-structure*) theory. A so-structure [1,6,8,9]
is a triple (X,≺,⊏), where ≺ and ⊏ are binary relations on X. They were invented to model both "earlier than" (the relation ≺) and "not later than" (the relation ⊏) relationships, under the assumption that all *system runs* (also called *observations*) are modelled by *stratified orders*, i.e., step sequences. They have been successfully applied to model inhibitor and priority systems, asynchronous races, synthesis problems, etc. (see for example [8,11,14] and others). However, so-structures can adequately model concurrent histories only when the paradigm π3 of [7,9] is satisfied. Paradigm π3 says that if two event occurrences are observed in both orders of execution, then they will also be observed executing simultaneously. Without this assumption, we need gso-structures, which were introduced and analyzed in [2]. The comprehensive theory for gso-structures has been developed in [5,15]. A gso-structure is a triple (X**,<>,**⊏), where <> and ⊏ are binary relations on X modelling "never simultaneously" and "not later than" relationships respectively under the assumption that all system runs are modelled by stratified orders. Intuitively, gso-structures can model even the situation when arXiv:0907.2775v1 [cs.AI] 16 Jul 2009