
## 4 A Semantic Mapping To Psl-Core

In this section, we will attempt to map a subset of Tgso to the PSL-core theory (T*pslcore*).

We let T −
gso to denote the theory consisting of axioms from (2.6) to (2.24) and the following two axioms.

$(\forall x)\left(\text{event\_occurrence}(x)\lor\text{observation}(x)\right)$  $(\forall x)\neg(\text{event\_occurrence}(x)\wedge\text{observation}(x))$
$\supset\!\!\!\!\supset x=y$) ]. 
Axiom (4.1) says that everything is either an *event occurrence* or an *observation*.

And axiom (4.2) says that the set of event occurrences and the set of observations are disjoint.

The reason for considering the theory T −
gso is that all of the interesting properties of Tgso concern with event occurrences and not with the events themselves. The second reason is that beside weakening the theory Tgso, we do not see how we can establish a semantic mapping from Tgso to T*pslcore* without introducing extra axioms into T*pslcore*.

To shorten our formulas, we need the following notation. For any formula P(x) we define
(∃!x) P(x)
≡
(∃x) P(x)
∧
(∀x,y) P(x)∧P(y) ⊃ x = y

$\left(\left(-\infty\right)T\left(x\right)\right)$ 3. 
In other words, we write (∃!x) P(x) to say that there exists a unique x satisfying P(x).

Definition 6 (Interpretation of T −
gso **into** Tpslcore). We let π *denote the relative interpretation of the language of* T −
gso into Tpslcore. Then the interpretation π *is defined as* follows:

|                                                                                             |                              |           |
|----------------------------------------------------------------------------------------------|------------------------------|-----------|
| πobservation(x) df =                                                                         | object(x)∧  (∀t)exists at(x,t)                               |           |
|                                                                                             |                             |           |
|                                                                                               | occurrence of(o,a)           |            |
| ∧ (∀a)(∃!o)                                                                                  | ∧ (∃!t)participate in(x,o,t) |          |
|                                                                                      |                              |           |
| df =                                                                                         |                              |           |
| πobserved before(a1,a2,x)                                                                    | πobservation(x)              |   |
|                                                                                         |                              |           |
|                                                                                        |                              |           |
| ∧ (∃o1,o2,t1,t2)                                                                             | occurrence of(o1,a1)         |           |
| ∧ occurrence of(o2,a2) ∧ participate in(x,o1,t1) ∧ participate in(x,o2,t2) ∧ before(t1,t2)  |                              |           |
|                                                                                      |                              |           |
| df =                                                                                         |                              |           |
| πobserved simult(a1,a2,x)                                                                    | πobservation(x)              |   |
|                                                                                         |                              |           |
|                                                                                        |                              |           |
| ∧ (∃o1,o2,t1,t2)                                                                             |                             |           |
| occurrence of(o1,a1)                                                                         |                              |           |
| ∧ occurrence of(o2,a2) ∧ participate in(x,o1,t1) ∧ participate in(x,o2,t2) ∧ t1 = t2         |                              |           |
| df = (∀x)  πobservation(x) ⊃ πobserved before(a1,a2,x)                                                                                               |                              |           |
| πearlier than(a1,a2)                                                                         |                              |           |

πevent occurrence(a)
df= activity(a)

$$(4.1)$$ $$(4.2)$$
