deviation from the optimal/best known solutions is rather small, which indicates that VNS is indeed an effective approach for most instances from the literature.

Unfortunately however, a considerable dispersion can be identified within these results. As shown in Table 6, the average results deviate for some few instances significantly more than in the majority of data sets. Even for some smaller instances, i. e. n = 40 and n **= 50, considerable**
deviations can be found in some cases.

Table 6: Average deviation of VNS-2 **from the optimal/best known solutions given in percent**

 2009

| n = 40   | n = 50   | n = 100   |     |     |     |      |      |     |     |     |     |      |     |     |     |     |
|----------|----------|-----------|-----|-----|-----|------|------|-----|-----|-----|-----|------|-----|-----|-----|-----|
| T F:     | 0.2      | 0.4       | 0.6 | 0.8 | 1.0 | 0.2  | 0.4  | 0.6 | 0.8 | 1.0 | 0.2 | 0.4  | 0.6 | 0.8 | 1.0 |     |
| RDD:     | 0.2      | 6.7       | 0.4 | 0.2 | 0.2 | 0.0  | 1.5  | 0.4 | 0.4 | 0.1 | 0.0 | 0.4  | 0.2 | 0.2 | 0.2 | 0.0 |
| 0.4      | 0.0      | 0.3       | 0.6 | 0.1 | 0.0 | 13.9 | 1.2  | 0.4 | 0.1 | 0.0 | 1.1 | 1.1  | 0.4 | 0.1 | 0.0 |     |
| 0.6      | 0.0      | 4.6       | 0.9 | 0.0 | 0.0 | 0.0  | 3.1  | 1.8 | 0.2 | 0.0 | 0.0 | 2.5  | 0.6 | 0.1 | 0.0 |     |
| 0.8      | 0.0      | 9.7       | 0.3 | 0.0 | 0.0 | 0.0  | 10.3 | 0.8 | 0.2 | 0.0 | 0.0 | 15.9 | 1.1 | 0.1 | 0.0 |     |
| 1.0      | 0.0      | 0.0       | 0.6 | 0.1 | 0.0 | 0.0  | 0.0  | 1.9 | 0.1 | 0.1 | 0.0 | 0.2  | 0.3 | 0.1 | 0.0 |     |

Combining the results of Table 5 and 6, an interesting observation emerges. While VNS-2 successfully solves the instances with T F = 0.2/RDD = 0.2, T F = 0.4/RDD = 0.6, T F = 0.4/RDD = 0.8 in the best case**, the results show a relative high deviation from the optimal/best**
known results in the average case**. On the other hand, instances that are not solved in the best**
case, i. e. the ones with T F = 0.6/RDD = 0.**8, are approximated very nicely in average.**

## 4.3 Computational Effort

The following Table 7 gives an overview about the required computational effort for finding a local

![0_image_0.png](0_image_0.png)

optimum, depending on the neighborhood operator/ metaheuristic and the problem size n.

MIC

Clearly, the length of the hillclimbing runs significantly increases with n**, and it becomes clear**

| Table 7: Average number of evaluations for finding a local optimum n = 40 n = 50 n = 100 EX 23,147 46,355 416,920 FSH 24,866 51,471 513,764 BSH 29,563 62,637 693,206 VNS-1 26,389 52,692 471,406 VNS-2 39,847 85,420 950,904   |
|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|

that for large values of n**, the identification of even a local optimum becomes intractable. On the** other hand, the basic operators EX, FSH and BSH **do not show bigger differences. On the contrary,**
the relatively best-performing neighborhood EX **requires less computations for finding (better) local** optima. Consequently, the effort for the execution of VNS-1 **is much smaller in comparison to** VNS-2**, as the latter implementation first invests in the computationally demanding identification** of qualitatively inferior local optima for BSH.

## Hamburg, Germany, July 13–16, 2009
