# Improvements For Multi-Objective Flow Shop Scheduling By Pareto Iterated Local Search

Martin Josef Geiger
∗

∗**Logistics Management Department,**
Helmut Schmidt University - University of the Federal Armed **Forces Hamburg**
Holstenhofweg 85, 22043 Hamburg, Germany mjgeiger@hsu-hh.de

## 1 Introduction

 2009

![0_image_0.png](0_image_0.png)

The flow shop scheduling problem consists in the assignment of a set of jobsJ={J1**, . . . , J**n},
each of which consists of a set of operationsJj={Oj1**, . . . , O**joj
} **onto a set of machines**M=
{M1, . . . , Mm} [5, 18]. Each operationOjk **is processed by at most one machine at a time, involving**
a non-negative processing timepjk. The result of the problem resolution is a schedulex**, defining for** each operationOjk a starting timesjk **on the corresponding machine. Several side constraints are**
present which have to be respected by any solutionx **belonging to the set of feasible schedules**X.

Precedence constraintsOjk⊲Ojk+1∀j = 1, . . . , n, k = 1, . . . , oj− **1 between the operations of a job** Jj assure that processing ofOjk+1 only commences after completion ofOjk**, thus**sjk+1>sjk+pjk.

In flow shop scheduling, the machine sequence in which the operations are processed by the machines is identical for all jobs, and for the specific case of the permutation flow shop scheduling the job sequence must also be the same on all machines.

MIC
The assignment of starting times to the operations has to be done with respect to one or several optimality criteria. Most optimality criteria are functions of the completion timesCj **of the jobs**
Jj,Cj=sjoj
+pjoj The most prominent optimality criteria are the maximum completion time (makespan)Cmax=
maxCj and the sum of the completion timesCsum=Pnj=1 Cj **. Others express violations of due**
datesdj of jobsJj . A due datedj defines a latest point of time until production of a jobJj **should**
be completed as the finished product has to be delivered to the **customer on or up to this date. A**
possible optimality criteria based on tardiness of jobs is e. g. the total tardinessTsum=Pnj=1 Tj, whereTj = max(Cj−dj, 0).

It is known, that for regular optimality criteria at least one active schedulex **does exist which**
is also optimal. The representation of an active schedule is possible using a permutation of jobs π = (π1, . . . , πn), where each πj stores a job Jk at position j**. The permutation is then decoded into**
an active schedule by assuming the starting times of all operations as early as possible with respect to the precedence constraints and the given sequence inπ**. As a consequence, the search is, instead**
of searching all possible schedules, restricted to the much **smaller set of active schedules only.**
Hamburg, Germany, June 13–16, 2009