This paper proves that there is no Turing machine producing a sequence of all computable functions on the set of natural numbers. The proof implies the existence of "computational" systems that cannot be modeled by predefined Turing machines if the systems are not isolated from their environment. Roughly speaking, these systems change their finite descriptions by interacting with an environment whose development is not completely predictable for practical and theoretical reasons. I argue that **the proof even**
applies to existing systems such as the Internet. Finally, I introduce a new type of systems by requiring that they be capable of "computing" functions not computable by Turing machines.

## 2 Incompleteness Theorem

A computable function **is a function that can be computed by a Turing machine, that is, it can be represented by an ordinary computer program. Thus,**
a computable function on the set of natural numbers N into N **can be regarded as a computer program producing a natural number in its output**
from any natural number in its input. An example of such a function f is f(n) = n + 1 which produces the successor n **+ 1 of any natural number** n.

The computable functions on the set of natural numbers can be regarded as models of computer programs and systems. The restriction to computable functions on the set of natural numbers is not relevant because inputs and outputs of computer programs and systems are represented as **binary digits.** Useful programs and systems should work for defined sets of inputs which correspond to subsets of the set of natural numbers. Such a definition can be extended to all natural numbers by assuming a default output for **inputs for** which the program or system is not defined. Ordinarily, a program or **system** is defined on a decidable set of inputs, that is, there is a program deciding whether or not an input is admissible. Thus, the computable functions on the set of natural numbers model an important class of computer **programs** and systems.

Incompleteness Theorem: **There is no Turing machine producing a**
sequence of all computable functions f1, f2**, ... on the set of natural numbers** N **into** N.

Proof**. We assume that there is such a Turing machine. We define a new**
computable function g on the set of natural numbers by g(n) = fn(n**) + 1**
for all natural numbers n. Because the sequence f1, f2**, ... contains all**