
## About The Semantic Web

History. The advent of the World Wide Web (WWW) gave mankind an enormous pool of available information. The WWW is based on a set of established standards, which guarantee interoperability at various levels: e.g., the TCP/IP protocol provides a basis for transportation of bits, on top HTTP and HTML provide a standard way of retrieving and presenting hyperlinked text documents. Applications could easily make use of this basic infrastructure, which led to the now existing WWW. However, nowadays the sheer mass of available documents and the insufficient representation of knowledge contained in documents makes "finding the right things" real work for human beings. A major shortcoming of HTML is that it is well suited for human consumption, but not for machine-processability. As such, to interpret the information given in documents the human has always to be in the loop. To overcome such shortcomings, ontologies recently have become a topic of interest in computer science. Ontologies provide a shared understanding of a domain of interest to support communication among human and computer agents, typically being represented in a machine-processable representation language. Thus, ontologies are seen as key enablers for the Semantic Web. Refer to the accompanying Knowledge Technology Fact Sheet on Ontologies (cf. http://www.ktweb.org/doc/Factsheet-Ontologies-0306.pdf) for more information. Ontobroker (initially developed at the Institute AIFB/University of Karlsruhe, and now commercialized by the company Ontoprise) and SHOE (University of Maryland) were two ontology-based systems ahead of their time. Both systems relied on additional semantic markup which was put into regular web pages, so-called annotations. The systems showed very early the feasibility of adding machine-processable semantics to web pages. Many ideas of this work made it into current Semantic Web standards of the W3C (see the later section on Standards). Both systems also heavily influenced the development trends of semantic technologies. In the following we will briefly characterize typical Semantic Web tools and give examples of existing commercial and academic tools. It is quite noteworthy that most tools are currently not only being used to build and maintain WWW applications, but also corporate intranet solutions. Ontology Editors allow for creation and maintenance of ontologies, typically in a graphically oriented manner. There exists a plethora of available implementations, each having its own specialty and different functionalities. Common to most editors is the ability to create a hierarchy of concepts (such as "Car is a subconcept of Motor Vehicle") and to model relationships between those concepts (such as "A car is driven by a person". More advanced editors also allow the modelling of rules, but to explain this is beyond the scope of this paper. OntoEdit is the most prominent commercial ontology editor (available from http://www.ontoprise.com). Unlike most other editors, OntoEdit comes with a strong inferencing backbone, Ontobroker, which allows the modelling and use of powerful rules for applications. Numerous extensions, so-called plugins, exist to adapt OntoEdit to different usage scenarios such as database mapping. Last, but not least, a full-fledged tool support is provided by the Ontoprise team which makes it attractive for companies. Protégé is the most well-known academic ontology editor with a long development history (available from http://protege.stanford.edu/). Similar to OntoEdit it is based on a flexible plugin framework. Numerous plugins have been provided so far which nicely demonstrate possible extensions for typical ontology editors. An example is the PROMPT plugin, which allows for merging of two given ontologies into a single one. KAON (http://kaon.semanticweb.org) is not only an ontology editor, but rather an open-source ontology management infrastructure targeted at business applications. It includes a comprehensive tool suite allowing easy ontology creation and management, as well as building ontology-based applications. An important focus of KAON is on integrating traditional technologies for ontology management and application with those used in business applications, such as relational databases. Annotation Tools allow for adding semantic markup to documents or, more generally, to resources. The great challenge here to automate the annotation task as much as possible to reduce the burden of manual annotation for large scale resources. A good place to find further information on annotation and authoring, a quite related topic, is http://annotation.semanticweb.org/. 

OntoMat-*Annotizer* (available from http://annotation.semanticweb.org/ontomat) is currently the most prominent annotation tool. It is based on a full-fledged annotation framework called CREAM, which is already being extended to support semi-automatic annotations of documents as well as annotation of databases. 

Inference Engines allow for the processing of knowledge available in the Semantic Web. In a nutshell, inference engines deduce new knowledge from already specified knowledge. Two different approaches are applicable here: having general logic based inference engines, and specialized algorithms (Problem Solving Methods). Using the first approach one can distinguish between different kinds of representation languages such as Higher Order Logic, Full First Order Logic, Description Logic, Datalog and Logic Programming (cf. http://semanticweb.org/inference.html). Recently, in a contest-like project three state-of-the-art inference engines were evaluated with quite interesting results (cf. http://www.projecthalo.com/). Inference engines are KTweb Knowledge Technology Fact Sheet - Semantic Web: Page 2 www.ktweb.org November 2003 