# Restart Strategy Selection Using Machine Learning Techniques

Shai Haim and Toby Walsh NICTA and School of Computer Science and Engineering University of New South Wales Sydney, Australia
{shai.haim,toby.walsh}@nicta.com.au Abstract. **Restart strategies are an important factor in the performance of conflict-driven Davis Putnam style SAT solvers. Selecting a**
good restart strategy for a problem instance can enhance the **performance of a solver. Inspired by recent success applying machine learning**
techniques to predict the runtime of SAT solvers, we present **a method**
which uses machine learning to boost solver performance through a smart selection of the restart strategy. Based on easy to compute features, we train both a satisfiability classifier and runtime models. We **use these**
models to choose between restart strategies. We present experimental results comparing this technique with the most commonly used restart strategies. Our results demonstrate that machine learning **is effective in** improving solver performance.

## 1 Introduction

Restarts have been shown to boost the performance of backtracking SAT solvers
(see for example [11],[24]). A restart strategy (t1,t2,t3**,...) is a sequence of restart**
lengths that the solver follows in the course of its execution. The solver first performs t1 **steps (in case of SAT solvers a step is usually a conflict). If a solution**
is not found, the solver abandons its current partial assignment and starts over.

The second time it runs for t2 **steps, and so on. Luby, Sinclair and Zuckerman**
[16] show that for each instance there exists t
∗
**, an optimal restart length that**
leads to the optimal restart strategy (t
∗
,t
∗
,t
∗
**,...). In order to calculate** t
∗
**, one**
needs to have full knowledge of the runtime distribution (RTD) of the instance, a condition which is rarely met in practical cases.

Since the RTD is not known, solvers commonly use "Universal Restart Strategies". These strategies do not assume prior knowledge of the RTD and they attempt to perform well on any given instance. Huang [11] shows that **when applied**
with Conflict Driven Clause Learning solvers (CDCL), none of the commonly used universal strategies dominates all others on all benchmark families. He also demonstrates the great influence on the runtime of different restart strategies, when all its other parameters are fixed.

In this paper we show that the recent success in applying machine learning techniques to estimate solvers' runtimes can be harnessed to improve solvers' arXiv:0907.5032v1 [cs.AI] 29 Jul 2009