for a given instance. We present *LMPick***, a machine learning based technique**
which enhances CDCL solvers' performance.

## 3.1 Restart Strategies Portfolio

LMPick **uses a portfolio of restart strategies from which it chooses the best one**
for a given instance. Following [11] we recognize several restart strategies that have shown to be effective on one benchmark family or more. We chose 9 restart strategies that represent, to our understanding, a good mapping of commonly used restart strategies.

- *luby-32 -* **A Luby restart strategy with a "unit run" of 32 conflicts. This**
strategy represents a Luby restart strategy with a relatively small "unit run". This technique was shown to be effective by Huang [11].

- *luby-512 -* **A Luby restart strategy with a "unit run" of 512 conflicts. This**
strategy represents a Luby restart strategy with a larger "unit **run". This is** the original restart scheme used by TiniSat, the solver we used in this study.

- *Fixed-512 -* **A fixed restart scheme with a restart size of 512 conflicts. Similar**
restart schemes that are used by solvers are BerkMin's *Fixed-550* **[8], and** the 2004 version of zChaff, *Fixed-700* **[17].**
- *Fixed-4096 -* **A fixed balance scheme with a restart size of 4096 conflicts.**
We chose this restart scheme because it balances the short and long fixed schemes, and because it performed very well in our preliminary tests.

- *Fixed-16384 -* **A fixed balance scheme with a restart size of 16384 conflicts.**
A longer fixed strategy, similar to the one used by Siege [21] (*Fixed-16000*).

- *Geometric-1.1 -* **A geometric restart scheme with a first restart size of 32**
conflicts and a geometric factor of 1.1. inspired by the one used by Hunag [11].

- *Geometric-1.5 -* **A geometric restart scheme with a first restart size of 100**
conflicts and a geometric factor of 1.5. This is the restart scheme used in MiniSat v1.14 [5].

- *Nested-1.1 -* **A nested restart strategy, with an inner value of 100 conflicts,**
an outer value of 1000 values and a geometric factor of 1.1. This strategy is parameterized as the one used by PicoSAT [2].

- *Nested-1.5 -* **A nested restart strategy, with an inner value of 100 conflicts,**
an outer value of 1000 values and a geometric factor of 1.5. Inspired by the results presented in [22].

## 3.2 Supervised Machine Learning

Satsifiable and unsatisfiable instances from the same benchmark family tend to have different runtime distributions [7]. A runtime prediction model **that is**
trained using both SAT and UNSAT instances performs worse than a **homogeneous model. It is better to train a layer of two models, one trained with**
satisfiable instances (Msat**) and the other with unsatisfiable instances (**Munsat).