# Online Search Cost Estimation For Sat Solvers

Shai Haim and **Toby Walsh**
{shai.haim,toby.walsh}@nicta.com.au School of Computer Science and Engineering, The University of New South Wales Sydney, Australia and NICTA
Sydney, Australia

## Abstract

We present two different methods for estimating the cost of solving SAT problems. The methods focus on the online behaviour of the backtracking solver, as well as the structure of the problem. Modern SAT solvers present several challenges to estimate search cost including coping with nonchronological backtracking, learning and restarts. Our first method adapt an existing algorithm for estimating the size of a search tree to deal with these challenges. We then suggest a second method that uses a linear model trained on data gathered online at the start of search. We compare the effectiveness of these two methods using random and structured problems. We also demonstrate that predictions made in early restarts can be used to improve later predictions. We conclude by showing that the cost of solving a set of problems can be reduced by selecting a solver from a portfolio based on such cost estimations.

## Introduction

Estimating the cost of solving a NP-hard problem like propositional satisfiability (SAT) is a difficult task. Simple backtracking SAT solvers like DPLL unfold a proper-binary decision tree. The Weighted Backtrack Estimate (WBE)
(Kilby et al. 2006), which is an adaptation of Knuth's offline sampling method (Knuth 1975) can generate good estimates of search cost for such solvers. However, more modern SAT
solvers present several challenges for estimating their runtime. For instance, clause learning repeatedly changes the problem the solver faces. Estimation of the size of the search tree at any point should take into consideration the expected changes that future learning clauses will cause. As a second example, restarting generates a new search tree which again needs to be taken into account by any prediction method.

Our approach to these problems is to use an on-line method to estimate the cost of the search by observing the solver's *behaviour* in a small part of search. Our first method is an extension of an existing method. It adapts the Weighted Backtrack Estimator (Kilby et al. 2006) to support non-chronological backtracking. Our second method uses machine learning. We show that using machine learning, it is possible to achieve good estimates at a very early stage of the search, by exploiting data gathered from other instances Copyright c 2021, Association for the Advancement of Artificial Intelligence (www.aaai.org). All rights reserved.

from the same ensemble. These two methods are tied together, since the tree size estimated by the WBE method is a useful feature for the machine learning method.

## Background

Knuth used probing sample to estimate the size of a backtrack search tree (Knuth 1975). If biis the branching rate observed at depth i of the probe, then 1 + b1 + b1 · b2 + **. . .**
is an unbiased estimation for the size of the tree. Despite its simplicity, this method is strikingly effective. Unfortunately, random probing cannot be directly used during backtrack search. Inspired by Knuth's method, Kilby et.

al. proposed two online methods to estimate the size of a search tree during backtracking search (Kilby et al. 2006):
The Weighted Backtrack Estimator, which is discussed in depth in the next section, and the Recursive Estimator.

The Recursive Estimator simply assumes that any unexplored right subtree is identical in size to the left subtree.

Both methods are unbiased and independent of the problem or solver, but since they are both estimating the size of a complete binary search tree, they do not work directly in modern solvers and perform poorly for most satisfiable instances. Kokotov and Shlyakhter suggested some similar techniques to the RE. The Progress Bar for SAT
Solvers (Kokotov and Shlyakhter 2000) estimates the remaining time to solving a SAT instance by observing previously visited nodes. The estimate is calculated using either historical or *predictive* heuristics. Historical estimators use the average observed for previous nodes at the same depth.

The *simple average* estimator just uses a straight forward average, whilst the *weighted average* favours more recent subtrees. Predictive estimators, on the other hand, are based on the size of the subproblem (e.g. number and size of the clauses)
Machine learning has also been used to estimate search cost. By observing the solver as it solves the problem, we might be able to estimate how long it will take for the solver to solve it. Horovitz et al used a Bayesian approach to classify CSP and SAT problems according to their runtime (Horvitz et al. 2001). Whilst this work is close to that presented here, there are some significant differences.

For example, they used SATz-Rand, which does not have some of the complex features tackled here such as clause learning. Xu et. al (Xu, Hoos, and Leyton-Brown 2007)