calculating:
 **Calculating**.: $$\frac{C}{P}-1$$ Where $C$ is the number of nodes encountered so far and: $$P=\frac{1}{\sum_{n\in closed}(2^{d(n)+1})}$$

![0_image_1.png](0_image_1.png)

$$({\mathfrak{I}})$$
Where d(n) is the depth of node n and **closed** is the subset of nodes in the current branch whose left child has been closed.

We can show this as follows:

![0_image_3.png](0_image_3.png)

Note that C = 2 |D| as C is increased by 2 for every conflict (once for the leaf and again for the node we backtrack to). Finally, we can show by induction on the depth of the tree that:

$$\sum_{d\in D}p o b(d)={\frac{1}{\sum_{n\in c l o s e d}(2^{d(n)+1})}}=P$$
= P (4)
where d(n) is the depth of node n and **closed** is the subset of the nodes in the current branch whose left child has been closed.

Both C and P can be computed incrementally as we branch and backjump. Since the search tree is not kept explicitly in memory, **closed** is computed using a bit array.

This increases the space and time complexity of calculating WBE by O(d) where d is the maximum depth. We can avoid increasing the amortized complexity if we estimate search cost at only every O(d) nodes.

Restarts create an extra challenge for WBE. Upon restarting, a new tree is generated. The search cost estimation therefore needs to change. Since WBE generate a *tree size* estimate, we can generate a cost estimation by adding the tree size estimated by WBE to the number of nodes explored until we reach a restart big enough to explore such a tree.

## Linear Model Prediction (Lmp)

To learn from more than just the size of previously explored search trees, we developed an online machine learning method. We estimate the runtime on a problem P∈ E,
when E is an ensemble of problems after training a linear model using a subset of problems T ⊂ E. For every training example t ∈ T a feature vector xt = {xt,1, xt,2, . . . , xt,k} is created from on observation window of the search tree. We

$\downarrow$ . 
F eature **init** *Observation Window*

![0_image_0.png](0_image_0.png)

![0_image_2.png](0_image_2.png)

cls/var √ √ √ √ √ √
var/cls √ √ √ √ √ √
F BC √ √ √ √
F T C √ √ √ √
ACS √ √ √ √
SD √ √ √
BSD √ √ √
BS √ √ √
LCS √ √ √ √
CCS √ √ √ √ ABB √ √ √ √
AAB √ √ √ √ AAB/ABB √ √ √ √
ABB/AAB √ √ √ √ LW BE √ √ √ √ √

$$\quad(4)$$

selected features by removing the feature with the smallest standardised coefficient until no improvement is observed based on the standard AIC (Akaike Information Criterion).

We then search for and eliminate co-linear features in the set.

Using ridge linear regression, we fit our coefficient vector w to create a linear predictor fw (xi) = w T xi. We chose ridge regression, since it is a quick and simple technique for numerical prediction, and it generally yields good results.

We predict the log of the number of conflicts. Since the feature vector is computed online, it is important that it does not add significant cost to search. The feature vector therefore only contains features that can be calculated in constant time. We define the *observation window* to be that part of the search where data is collected. At the end of the observation window, the feature vector is computed and the model queried for an estimation.

The feature vector measures both problem structure and search behaviour. Since data gathered at the start of a restart tends to be noisy and less useful, we do not open the observation window immediately. To keep the feature vector a reasonable size, we use statistical measures of various parameters (that is, the minimum over the observation window, the maximum, the mean, the standard deviation and the last value recorded). The parameters collected are the number of variables (var), the number of clauses (cls), both the variable to clause ratio and its inverse, the fraction of binary and ternary clauses in the clause database (**F BC** and **F T C** respectively), the average clause size (ACS), the search depth as it appears in the assignment stack (SD) and as it appears in the binary tree generated for the WBE calculation(BSD),
the learnt clauses size (LCC) and the conflict clause size (CCS), the fraction of assigned vars before backtracking
(ABB) and after backtracking (AAB), the ratio between these two features and its inverse, and the log of the WBE