
| Dataset   | Oracle   | LMP (oracle)   | LMP(AVG)   |      |
|-----------|----------|----------------|------------|------|
| rand      | sat      | 40.8           | 7.0        | 10.5 |
| unsat     | 7.5      | -0.9           | -1.4       |      |
| fv        | sat      | 66.7           | 17.2       | 16.8 |
| unsat     | 14.8     | -0.6           | -3.3       |      |
| bmc       | sat      | 59.6           | 13.3       | 13.6 |
| unsat     | 17.2     | 0.3            | -0.4       |      |

Table 4: Percentage improvement over average run time for both solver A and B.

![0_image_0.png](0_image_0.png)

## The Problem (Min(**A, B**)).

- *LMP (oracle):* Use both solvers until each reaches the observation window (restart 9 for solver A, restart 19 for solver B), and generate a prediction, using an oracle that indicates which model should be queried. Terminate the one predicted to be worse.
- *LMP (AVG):* Same as *LMP (oracle)*, but without an oracle to determine whether the instance is sat or *unsat*. We instead query both models and use the geometric mean as the prediction.

These results show that for satisfiable problems, where solver performance varies more significantly, our method reduces the total cost. For unsatisfiable problems, where solvers performance does not vary as much, our method does not improve search cost. However, as performance does not change significantly on unsatisfiable instances, the overall impact of our method on satisfiable and unsatisfiable problems is positive.

## Conclusions And Future Work

We have presented two different methods to generate estimates for the size of the search tree explored by modern day SAT solvers. The WBE method simply observes the search tree and requires no prior knowledge of the problem distribution. This method, like other tree-size based methods performs poorly for satisfiable instances. The LMP method, on the other hand, uses linear models which are trained on a problem set. We have shown that it is possible to train the model using a relatively small training set, which is of value when training examples are in short supply. We have demonstrated the effectiveness of both method on random problems, as well as on bounded model checking and hardware verification problems. We also proposed a simple way to use such predictions to select between different SAT solvers.

There are many directions for future work. For instance, we conjecture it may be effective to use these methods to select between very different types of solver. We are currently using LMP to select between a geometric restart strategy and Luby's restart scheme.

## Acknowledgements

This paper contains work that is to appear in (Haim and Walsh 2008). In particular, the LMP method is described in (Haim and Walsh 2008). However, the extension of the WBE method to conflict driven solvers, along with all results comparing WBE and LMP to the Progress Bar for SAT Solvers are presented here for the first time.

The second author is funded by the Department of Broadband, Communications and the Digital Economy, and the Australian Research Council.

## References

[Een and Sorensson 2003] Een, N., and Sorensson, N.

2003. An extensible SAT-solver. SAT 2919:502–518.

[Haim and Walsh 2008] Haim, S., and Walsh, T. 2008. Online Estimation of SAT Solving Runtime. *Lecture Notes in* Computer Science. In Press.

[Horvitz et al. 2001] Horvitz, E.; Ruan, Y.; Gomes, C.;
Kautz, H.; Selman, B.; and Chickering, M. 2001. A
bayesian approach to tackling hard computational problems. *Proceedings the 17th Conference on Uncertainty in* Artificial Intelligence (UAI-2001).

[Kilby et al. 2006] Kilby, P.; Slaney, J.; Thi´ebaux, S.; and Walsh, T. 2006. Estimating search tree size. In *Proceedings of the Twenty-First National Conference of Artificial* Intelligence, AAAI.

[Knuth 1975] Knuth, D. 1975. Estimating the Efficiency of Backtrack Programs. *Mathematics of Computation* 29(129):121–136.

[Kokotov and Shlyakhter 2000] Kokotov, D., and Shlyakhter, I. 2000. Progress Bar for SAT Solvers.

In *Unpublished manuscript, http://sdg. lcs. mit.* edu/satsolvers/progressbar.html.

[Leyton-Brown, Nudelman, and Shoham 2002] LeytonBrown, K.; Nudelman, E.; and Shoham, Y. 2002. Learning the empirical hardness of optimization problems: The case of combinatorial auctions. In *CP '02: Proceedings of the* 8th International Conference on Principles and Practice of Constraint Programming, 556–572. Springer-Verlag.