- UL (¯x) ≤ U(x) ≤ UU (¯x) - UL (¯x) → U (x) and UU (¯x) → U (x**) as ¯**x → x.

In any case, we will not assume that U **is computable, because we do not need**
such a strong assumption to prove our claims. Instead we will define **two possible** conditions.

Definition 1. Let D ⊆ XN and let U : D → R*. Let* Dp = {s ∈ X∗|(∃d ∈ D) : s ⊑
d}*. Then* U is **computably unbounded from above** on D if there exists a computable partial function UL : Dp → Z *such that:*
- (∀d ∈ D) (∀s ∈ Dp) : if s ⊑ d, and if UL (s) *exists, then* UL (s) ≤ U (d). - (∀m ∈ Z) (∃s ∈ Dp) : UL (s) > m.

U is *computably unbounded from below* if −U **is computably unbounded from**
above.

Note in particular that any computable function on XN **which is unbounded from**
above is computably unbounded from above, and any computable function which is unbounded from below is computably unbounded from below.

The following lemma will help us find environments which generate large amounts of utility. When considering f in the lemma, think of UL **above.**
Lemma 1. Suppose C ⊆ X∗, and f : C → Z *is a computable partial function such* that (∀m ∈ Z) (∃c ∈ C) : f (c) > m*. Then there exists a computable total function* H : Z → C *such that,* (∀m ∈ Z) : f ◦ H (m) ≥ m.

In other words, given an *unbounded* partial function f**, there is a computable**
function H which finds an input on which f **will exceed any given bound.**
Proof. First we'll index C; let C = {c1, c2**, . . .** }.

If f were a total function, we could simply let H (m) = cmin{i∈N:f(ci)>m}**. We**
would compute this by first computing f(c1), then f(c2**), etc. Unfortunately we**
only have that f **is a partial function, so we can not proceed in this way.**
Instead, we'll note that for any input on which f **halts, it must halt in a specific**
number of steps. The Cantor pairing function π : N × N → N, π (k1, k2) = 12
(k1 +
k2)(k1 + k2 + 1) + k2 **is a bijection, so we can use** π
−1**to index all pairs of natural**
numbers. Then we can simulate f **on every possible input for every number of** steps, which will allow us to evaluate f on every input for which f **halts.**

## Def H(M):

for n in (1, 2, 3, ...):
let (t, i) = pi^-1(n)
simulate f(c_i) for t steps
... if it does not finish:
do nothing.

... if it does finish:
if f(c_i) >= m:
return c_i Then H **is a computable total function and** f ◦ H (m) ≥ m. 