needs to be implemented and the propagator for not-last can be derived (or vice versa). This is in particular beneficial if the algorithms use sophisticated data structures such as Ω-trees [37]. Here, also the data structure needs to be implemented only once and the dual data structure for the dual propagator is derived.

## 4.2 Generalization

Common views for integer variables capture linear transformations of the integer values: an *offset view* for o ∈ Z on x is defined as ϕx(v) = v+o, and a *scale view* for a ∈ Z
on x is defined as ϕx(v) = av.

Offset and scale views are useful for generalizing propagators. Generalization has two key advantages: simplicity and efficiency. A more specialized propagator is often simpler to implement (and simpler to implement correctly) than a generalized version.

The specialized version can save memory and runtime during execution.

We can devise an efficient propagation algorithm for a linear equality constraint
∑
n i=1 xi = c for the common case that the linear equation has only unit coefficients.

The more general case ∑
n i=1 aixi = c can be derived by using scale views for ai on xi (the same technique of course applies to linear inequalities and disequality rather than equality). Similarly, a propagator for *all-different*(x1,...,xn) can be generalized to *all-different*(c1 + x1,...,cn + xn) by using offset views for ci ∈ Z on xi. Likewise, from a propagator for the element constraint a[x] = y for integers a1,...,an and integer variables x and y, we can derive the generalized version a[x+o] = y with an offset view, where o ∈ Z provides a useful offset for the index variable x.

These generalizations can be applied to domain- as well as bounds-complete propagators. While most Boolean propagators are domain-complete, bounds completeness plays an important role for integer propagators. Section 3.3 shows that, given appropriate hull-surjective and/or hull-injective views, the different notions of bounds consistency are preserved when deriving propagators.

The views for integer variables presented in this section have the following properties: minus and offset views are hull-bijective, whereas a scale view for a ∈ Z on x is always hull-injective and only hull-surjective if a = 1 or a = −1 (in which cases it coincides with the identity view or a minus view, respectively).

## 4.3 Specialization

We employ *constant views* to specialize propagators. A constant view behaves like an assigned variable. In practice, specialization has two advantages. Fewer variables require less memory. And specialized propagators can be compiled to more efficient code, if the constants are known at compile time.

Examples for specialization are
- a propagator for binary linear inequality x+y ≤ c derived from a propagator for x+y+z ≤ c by using a constant 0 for z;

- a reified propagator for (x = c) ↔ b from (x = y) ↔ b and a constant c for y;
- propagators for the counting constraints | {i | xi = c}| = z and | {i | xi = y}| = c from a propagator for | {i | xi = y}| = z;
- a propagator for set disjointness from a propagator for x∩y = z and a constant empty set for z; and many more.