We have to straightforwardly extend the model for constant views. Propagators may now be defined with respect to a superset of the variables, X
′ ⊇ X. A constant view for the value k on a variable z ∈ X
′ \X translates between the two sets of variables:
ϕ(c) = {a[k/z] | a ∈ c} ϕ
−(c) = a|X
 a ∈ c
	
Here, a[k/z] means augmenting the assignment a so that it maps z to k, and a|X is the functional restriction of a to the set X.

It is important that this definition preserves failure. If a propagator returns a failed domain d that maps z to the empty set, then ϕ
−(d) is the empty set, too (recall that this is really ϕ
−(con(d)), and con(d) = /0 if d(z) = /0).

## 4.4 Type Conversion

A type conversion view lets propagators for one type of variable work with a different type, by translating the underlying representation. Our model already accommodates for this, as a view ϕx maps elements between different sets V and V
′.

Integer views. Boolean variables are essentially integer variables restricted to the values {0,1}. Constraint programming systems may choose a more efficient implementation for Boolean variables and hence the variable types for integer and Boolean variables differ. By wrapping an efficient Boolean variable in an *integer view*, all integer propagators can be directly reused with Boolean variables. This can save substantial effort: for example, an implementation of the *regular*-constraint for Boolean variables can be derived which is actually useful in practice [19].

Singleton set views. A *singleton set view* on an integer variable x, defined as ϕx(v) =
{v}, presents an integer variable as a set variable. Many constraints involve both integer and set variables, and some of them can be expressed with singleton set views. A
simple constraint is x ∈ y, where x is an integer variable and y a set variable. Singleton set views derive it as {x} ⊆ y. This extends to {x} ⋄ y for all other set relations ⋄.

Singleton set views can also be used to derive pure integer constraints from set propagators. For example, the constraint *same*(x1,...,xn,y1,...,ym) with integer variables xi,yi states that the variables xitake the same values as the variables yi. With singleton set views, Sn i=1{xi} =
Sm j=1{yj} implements this constraint (albeit with weaker propagation than the algorithm presented in [4]). Set bounds and complete set domain variables. Most systems approximate set variable domains as set intervals defined by lower and upper bounds [25, 13]. However, [16] introduces a representation for the complete domains of set variables, using ROBDDs. Type conversion views can translate between set interval and ROBDDbased implementations. We can derive a propagator on ROBDD-based variables from a set interval propagator, and thus reuse set interval propagators for which no efficient ROBDD representation exists.

## 4.5 Applicability And Return On Investment

To get an overview of how applicable the presented techniques for propagator derivation are, let us consider the use of views in Gecode (version 3.1.0). Table 1 shows the number of propagator implementations and the number of propagators derived from the