template<class VX, class VY> class Eq : public **Propagator {**
protected: VX* **x; VY*** y; public: Eq(VX* x0, VY* **y0) : x(x0), y(y0) {}**
virtual void propagate(void) {
x->adjmin(y->min()); x->adjmax(y->max()); y->adjmin(x->min()); y->adjmax(x->max());
}
};
Figure 3: Parametric equality propagator

## 5.2 Deriving Propagators

In order to derive a propagator using view objects like the above, we use *parametricity*, a mechanism provided by the implementation language that supports the instantiation of the same code (the propagator) with different parameters (the views).

Figure 3 shows a simple equality propagator. The propagator is based on C++ templates, it is *parametric* over the types of the two views it uses and can be *instantiated* with any view that provides the necessary operations. This type of parametricity is called *parametric polymorphism*, and is available in other programming languages for example in the form of Java generics [14] or Standard ML functors [22].

Given two pointers to integer variables x and y, the propagator can be instantiated to implement Jx = yK as follows (using the **IntVar** class from Figure 2):
new **Eq<IntVar,IntVar>(x,y);**
The following instantiation yields a propagator for Jx = y+2K:
new Eq<IntVar,OffsetView>(x,new **OffsetView(y,2));**
Events. Most constraint solvers schedule the execution of propagators according to events (see for example [31]). For example, a propagator p for Jx < yK can only prune the domain (and thus should only be executed) if either the lower bound of x or the upper bound of y changes, written lbc(x) and ubc(y). We say that *p subscribes* to the event set {lbc(x),ubc(y)}.

Now assume that p
′is derived from p using minus views on x and y, thus implementing x > y. Obviously, p
′should subscribe to the dual event set, {ubc(x),lbc(y)}.

In the implementation, views provide all the operations needed for event handling (such as subscription) and perform the necessary transformations of event sets.

## 5.3 Parametricity

Independent of the concrete implementation, views form an orthogonal layer of abstraction on top of any propagation-based constraint solver. As long as the implementation language provides some kind of parametricity, and variable domains are accessed through some form of variable objects, propagators can be derived using views.

In addition to parametric polymorphism, two other forms of parametricity exist, functional parametricity and *dynamic binding*. Functional parametricity means that in languages such as Standard ML [22] or Haskell [24], a higher-order function is parametric over its arguments. Dynamic binding is typically coupled with inheritance in object-oriented languages (virtual function calls in C++, method calls in Java). Even