In order to access and update these set bounds, propagators use set-valued operations based on iterators: x.glb() returns a range iterator for ranges(glb(d(x))),
x.lub() returns a range iterator for ranges(lub(d(x))), x.**adjglb**(r) updates the domain of x to [glb(d(x))∪set(r),lub(d(x))], and x.**adjlub**(r) updates the domain of x to [glb(d(x)),lub(d(x))∩set(r)].

Iterator combinators provide the operations that set propagators need: union, intersection, difference, and complement. Many propagators can thus be implemented directly using iterators and do not require any temporary data structures for storing set-valued intermediate results.

All set-valued operations are parametric with respect to the iterator r: any range iterator can be used. As for parametric propagators, an implementor has to decide on the kind of parametricity to use. Gecode uses template-based parametric polymorphism, with the performance benefits due to monomorphization and consequent code optimization mentioned previously.

Advantages. Range iterators provide essential advantages over an explicit set representation. First, any range iterator regardless of its implementation can be used in domain operations. This turns out to result in simple, efficient, and expressive domain updates. Second, no costly memory management is required to maintain a range iterator as it provides access to only one range at a time. Third, the abstractness of range iterators makes them compatible with views and derived propagators: the necessary view transformations can be encapsulated in an iterator, as discussed below. Iterators for views. As iterators hide their implementation, they are perfectly suited for implementing the transformations required for set-valued operations on views.

Set-valued operations for constant integer views are straightforward. For a constant view v on constant k, the operation v.**getdom**() returns an iterator for the singleton range sequence h[k .. k]i. The operation v.**setdom**(r) just checks whether the range sequence of r is empty (in order to detect failure).

Set-valued operations for an offset view are provided by an *offset iterator*. For a range sequence r = h[mi.. ni]i k i=1 and offset c, ioffset(r,c) iteratesh[mi +c .. ni +c]i k i=1
.

An offset view on x with offset c then implements **getdom** as ioffset(x.**getdom**(),c) and setdom(r) as x.**setdom**(ioffset(r,−c)).

For minus views we just give the range sequence, iteration is obvious. For a given range sequence h[mi.. ni]i k i=1
, the negative sequence is obtained by reversal and sign change as h[−nk−i+1 .. −mk−i+1]i k i=1
. The same iterator for this sequence can be used both for **setdom** and **getdom** operations. Note that implementing the iterator is involved as it changes direction of the range sequence. There are two different options for changing direction: either the set-valued operations accept iterators in both directions or a cache iterator is used to reverse the direction. Gecode uses the latter and Section 7.2 evaluates the overhead introduced by cache iterators.

A scale iterator provides the necessary transformations for scale views. Assume a scale view on a variable x with a coefficient a > 0, and let h[mi.. ni]i k i=1 be a range sequence for d(x). If a = 1, the scale iterator does not change the range sequence. Otherwise, the corresponding scaled range sequence is h{a×m1},{a×(m1+1)},...,{a×
n1},...,{a × mk}, {a × (mk + 1)},...,{a × nk}i. For the other direction, assume we want to update the domain using a set S through a scale view. Assume thath[mi.. ni]i k i=1 is a range sequence for S. Then for 1 ≤ i ≤ k the ranges [⌈mi/a⌉ .. ⌊ni/a⌋] correspond to the required variable domain for x, however they do not necessarily form a range