sequence as the ranges might be empty, overlapping, or adjacent. Iterating the range sequence is however simple by skipping empty ranges and merging overlapping or adjacent ranges. Scale views for a variable x and a coefficient a in Gecode are restricted to be strictly positive so as to not change the direction of the scaled range sequence. A negative coefficient can be obtained by using a scale view together with a minus view.

A complement view of a set variable x uses a *complement iterator*, which given a range iterator r iterates over set(r).

## 6 Limitations

Although views are widely applicable, they are no silver bullet. This section explores some limitations of the presented model. Beyond injective views. Views are required to be injective, as otherwise ϕ
− ◦ ϕ is no longer the identity function, and derived propagators would not necessarily be contracting. An example for this behavior is a view for the absolute value of an integer variable. Assuming a variable domain d(x) = {1}, an absolute value view ϕ would leave the domain as it is, ϕ(d)(x) = {1}, but the inverse would "invent" the negative value, ϕ
−(ϕ(d))(x) = {−1,1}. With an adapted definition of derived propagators, such as ϕb(p)(d) = ϕ
−(p(ϕ(d))) ∩ d, non-injective views could be used - however, many of the proofs in this paper rely on injectivity (though some of the theorems possibly still hold for non-injective views).

Multi-variable views. Some multi-variable views that seem interesting for practical applications do not preserve contraction, for instance a view on the sum or product of two variables. The reason is that removing a value through the view would have to result in removing a *tuple* of values from the domain. As domains can only represent Cartesian products, this is not possible in general. Such a view would have two main disadvantages. First, if propagation of the original constraint is strong but does not lead to an actual domain pruning through the views, then the potentially high computational cost for the pruning does not pay off. A cheaper but weaker, dedicated propagation algorithm or a different modeling with stronger pruning is then a better choice. Second, if views do not preserve contraction, then Proposition 5 does not hold. That means that a propagator p cannot easily detect subsumption any longer, as it would have to detect it for ϕb(p) instead of just for itself, p. Systems such as Gecode that disable subsumed propagators (as described in [33]) then lose this potential for optimization.

For contraction-preserving views on multiple variables, all the theorems still hold.

Two such views we could identify are a set view of Boolean variables [b1,...,bn], behaving like {i | bi = 1}; and an integer view of Boolean variables [b1,...,bn], where biis 1 if and only if the integer has value i; as well as the inverse views of these two.

Propagator invariants. Propagators typically rely on certain invariants of a variable domain implementation. If idempotency or completeness of a propagator depend on these invariants, type conversion views lead to problems, as the actual variable implementation behind the view may not respect the same invariants.

For example, a propagator for set variables based on the set interval approximation can assume that adjusting the lower bound of a variable does not affect its upper bound. If this propagator is instantiated with a type conversion view for an ROBDD-based set