
Benchmark time % mem. % *propagations %*

Alpha (naive) 412.88 360.87 673.83 BIBD (7-3-60) 308.80 211.94 256.12

Eq-20 590.35 700.00 704.57 Partition (32) 135.61 113.58 136.40 Perfect Square 114.46 109.67 104.42 Queens (Dom, 10) 173.32 100.00 519.68

Queens (Dom, 100) 140.60 103.11 2371.86 Social Golfers (8-4-9) 335.89 234.82 160.22 Social Golfers (5-3-7) 217.28 190.69 150.58 Hamming Codes (20-3-32) 113.81 104.66 99.65 Steiner Triples (9) 132.79 100.00 101.76 Sudoku (Set, 1) 166.18 100.00 110.38 Sudoku (Set, 4) 152.82 110.81 107.06 Sudoku (Set, 5) 143.63 100.00 105.47

As many of the experimental results rely on the optimization capabilities of the used C++ compiler, we verified that all experiments yield similar results with the Microsoft Visual Studio 2008 C++ compiler.

## 7.1 Views Versus Decomposition

In order to evaluate whether deriving propagators is worth the effort in the first place, this set of experiments compares derived propagators with their decompositions, revealing a significant overhead of the latter.

Table 3 shows the results of these experiments. For *Alpha* and *Eq-20*, linear equations with coefficients are decomposed. For *Queens 100*, we replace the special *alldifferent*-with-offsets by its decomposition into an *all-different* propagator and binary equality-with-offset propagators. In *BIBD* and *Perfect Square*, we decompose ternary Boolean propagators, implementing x∧y ↔ z as ¬x∨¬y ↔ ¬z in *BIBD*, and x∨y ↔ z as ¬x ∧ ¬y ↔ ¬z in *Perfect Square*. In the remaining examples, we decompose a set intersection into complement and union propagators.

Some integer examples show a significant overhead of around six times the runtime and memory when decomposed. The overhead of most set examples as well as Perfect Square is moderate, partly because no additional variable was introduced if the model already contained its complement or negation. As to be expected, decomposition often needs significantly more propagation steps, but as the additional steps are performed by cheap propagators (like x = y + i or x = ¬y), the runtime effect is less drastic. *Queens 100* is an extreme case, where 23 times the propagation steps only cause 40% more runtime. The reason is that the scheduling order does not take advantage of the fact that the decompositions are Berge-acyclic as discussed in Section 3.5.

Partition 32 has a single linear equation with coefficients, several linear equations with unit coefficients, multiplications, and a single *all-different*. Replacing the linear equation by its decomposition has little effect on the runtime (35% overhead).

## 7.2 Impact Of Derivation Techniques

The techniques presented in Section 4 have different impacts on the performance of the derived propagators.