
| Benchmark               | time %   | prop. %   |
|-------------------------|----------|-----------|
| All-Interval (50)       | 100.00   | 100.00    |
| All-Interval (100)      | 100.52   | 100.00    |
| Alpha (naive)           | 101.81   | 100.00    |
| Golomb Rulers (Bnd, 10) | 99.36    | 100.01    |
| Golomb Rulers (Dom, 10) | 107.77   | 100.18    |
| Graph Coloring          | 107.19   | 99.84     |

| Benchmark         | time %   | prop. %   |
|-------------------|----------|-----------|
| Partition (32)    | 131.83   | 135.95    |
| Queens (10)       | 98.32    | 100.00    |
| Queens (Dom, 10)  | 107.63   | 100.00    |
| Queens (100)      | 97.83    | 100.00    |
| Queens (Dom, 100) | 95.62    | 100.00    |
| Sorting (400)     | 105.13   | 100.00    |

Generalization and specialization. These techniques can be implemented without any performance overhead compared to a handwritten propagator. This is not surprising as the only potential overhead could be that a function call is not resolved at compile time. For example, a thorough inspection of the code generated by the GNU C++ compiler and the Microsoft Visual Studio C++ compiler shows that they are able to fully inline the operations of offset and scale views.

Transformation and type conversion. These techniques can incur an overhead compared to a dedicated implementation, as the transformations performed by the views can sometimes not be removed by compiler optimizations, and type conversions may be costly if the data structures for the variable domains differ significantly.

For example, a propagator instantiated with two minus views of variables x and y may include a comparison, (−x) < (−y). Due to the invariants guaranteed by views, this is equivalent to y < x, saving two negations. However, the asymmetry in the two's complement representation of integers prevents the compiler from performing this optimization. As an experiment to evaluate this effect, we instantiated an *all-different* propagator with minus views. The resulting derived propagator of course implements the same constraint, but incurs the overhead of negation. Similarly, we replaced the max propagator in the *Sort* example with a min (where the propagator for min is derived from the propagator for max) and negated all parameters. According to the results in Table 4, the overhead is often negligible, and only exceeds 5% in examples that use the domain-complete *all-different* propagator (Graph Coloring, *Golomb Rulers Dom* and *Queens Dom*) or predominantly min propagators (Sort). *Queens Dom 100* does not show the effect as the runtime is dominated by search. Using minus views can result in different propagator scheduling. The *Partition* example shows this behavior, where the increase in propagation steps results in increased runtime.

It is interesting to note that the domain-complete *all-different* propagator, when instantiated with minus views, requires a cache iterator for sequence reversal (as discussed in Section 5.4). Surprisingly, the overhead of minus views is largely independent of the use of cache iterators which is confirmed in Section 7.4.

Other transformations are translated optimally, such as turning (−x) − (−y) into y−x. Boolean negation views also lead to optimal code, as they do not compute 1−x for a Boolean variable x, but instead swap the positive and negative operations.

Set-valued transformations can result in non-optimal code. For example, a propagator for ternary intersection, x = y∩z, will include an inference x.adjglb(y.glb()∩
z.glb()). To derive a propagator for x = y∪z, we instantiate the intersection propagator with complement views for x, y, and z, yielding the following inference:
x.adjglb(y.glb()∩z.glb())