
| Benchmark               | time %   |           |        |
|-------------------------|----------|-----------|--------|
| Social Golfers (8-4-9)  | 166.31   |           |        |
| Social Golfers (5-3-7)  | 148.83   |           |        |
| Hamming Codes (20-3-32) | 129.11   |           |        |
| Steiner Triples (9)     | 127.85   | Benchmark | time % |
| Sudoku (Set, 1)         | 167.44   |           |        |
| Sudoku (Set, 4)         | 151.74   |           |        |
| Sudoku (Set, 5)         | 142.83   |           |        |

Table 6: Relative performance of virtual method calls

| Benchmark                   | time %   |           |        |
|-----------------------------|----------|-----------|--------|
| All-Interval (50)           | 182.63   |           |        |
| All-Interval (100)          | 113.20   |           |        |
| Alpha (naive)               | 153.59   |           |        |
| BIBD (7-3-60)               | 138.50   |           |        |
| Eq-20                       | 211.69   |           |        |
| Golomb Rulers (Bnd, 10)     | 220.01   |           |        |
| Golomb Rulers (Dom, 10)     | 170.13   |           |        |
| Graph Coloring              | 104.29   |           |        |
| Magic Sequence (Smart, 500) | 136.58   |           |        |
| Magic Sequence (GCC, 500)   | 226.64   |           |        |
| Partition (32)              | 187.89   |           |        |
| Perfect Square              | 130.64   |           |        |
| Queens (10)                 | 133.81   |           |        |
| Queens (100)                | 160.79   | Benchmark | time % |
| Social Golfers (8-4-9)      | 148.37   |           |        |
| Social Golfers (5-3-7)      | 138.95   |           |        |
| Hamming Codes (20-3-32)     | 131.37   |           |        |
| Steiner Triples (9)         | 149.08   |           |        |
| Sudoku (Set, 1)             | 119.56   |           |        |
| Sudoku (Set, 4)             | 118.78   |           |        |
| Sudoku (Set, 5)             | 119.17   |           |        |

## X.Adjlub(Y.Lub()∩Z.Lub())

It would be more efficient to implement the equivalent x.adjlub(y.lub()∪z.lub())
because this requires three set operations less. Unfortunately, no compiler will find this equivalence automatically, as it requires knowledge about the semantics of the set operations. Table 5 compares a dedicated propagator for the constraint x∩y = z with a version using complement views and a propagator for x∪y = z. The overhead of 27%
to 67% does not render views useless for set variables, but it is nevertheless significant.

## 7.3 Templates Versus Virtual Methods

As suggested in Section 5, in C++, compile-time polymorphism using templates is far more efficient than virtual method calls. To evaluate this, we changed the basic operations of integer variables to be virtual methods, such that view operations need one virtual method call. In addition, all operations that use templates (and can therefore not be made virtual in C++) have been changed so that they cannot be inlined, to simulate virtual method calls. This is a conservative approximation of the actual cost of fully virtual views. The results of these experiments appear in Table 6. Virtual method calls cause a runtime overhead between 4% and 127% for the integer examples (left table),
and 18% to 49% for the set examples (right table). The runtime overhead for set examples is lower as the basic operations on set variables are considerably more expensive than the basic operations on integer variables.