Variables, constraints, and domains. Constraint satisfaction problems use a finite set of variables X and a *finite set of values V*. We typically write variables as x,y,z ∈ X and values as v,w ∈ V.

A solution of a constraint satisfaction problem assigns a single value to each variable. A constraint restricts which assignments of values to variables are allowed.

Definition 1 (Assignments and constraints) An *assignment a* is a function mapping variables to values. The set of all assignments is Asn = X → V. A *constraint c* is a set of assignments, c ∈ Con = P(Asn) = P(X → V) (we write P(S) for the power set of S). Any assignment a ∈ c is a *solution* of c. ∗
Constraints are defined on assignments as total functions on all variables. For a typical constraint c, only a subset vars(c) of the variables is *significant*; the constraint is the full relation for all x ∈/ vars(c). Constraints are either written as sets of assignments
(for example, {a ∈ Asn | a(x) < a(y)}) or as expressions with the usual meaning, using the notation J·K (for example, Jx < yK). Example 2 (Sum constraint) Let X = {x,y,z} and V = {1,2,3,4}. The constraint Jx = y+zK corresponds to the following set of assignments:
Jx = y+zK = {(x 7→ a,y 7→ b,z 7→ c) | a,b,c ∈ V ∧a = b+c}
= {(x 7→ 2,y 7→ 1,z 7→ 1),(x 7→ 3,y 7→ 1,z 7→ 2),
(x 7→ 3,y 7→ 2,z 7→ 1),(x 7→ 4,y 7→ 2,z 7→ 2)} ∗
Definition 2 (Domains) A *domain d* is a function mapping variables to sets of values, such that d(x) ⊆ V. The set of all domains is Dom = X → P(V). The set of values in d for a particular variable x, d(x), is called the *variable domain* of x. A domain d represents a set of assignments, a constraint, defined as con(d) = {a ∈ Asn | ∀x ∈ X : a(x) ∈ d(x)}
An assignment a ∈ con(d) is *licensed* by d. ∗
Domains thus represent *Cartesian* sets of assignments. In this sense, any domain is also a constraint. For a more uniform representation, we take the liberty to use domains as constraints. In particular, a ∈ d (instead of a ∈ con(d)) denotes an assignment a licensed by d, and c∩d denotes c∩con(d).

A domain d that maps some variable to the empty value set is *failed*, written d = /0, as it represents no valid assignments (con(d) = /0). A domain d representing a single assignment, con(d) = {a}, is *assigned*, and is written as d = {a}.

Definition 3 (Constraint satisfaction problems) A *constraint satisfaction problem*
(CSP) is a pair hd,Ci of a domain d and a set of constraints C. The *solutions* of a CSP hd,Ci are the assignments licensed by d that satisfy all constraints in C, defined as sol(hd,Ci) = {a ∈ con(d) | ∀c ∈ C : a ∈ c}. ∗
Propagators. A propagation-based constraint solver employs *propagators* to implement constraints. A propagator for a constraint c takes a domain d as input and removes values from the variable domains in d that are in conflict with c.

A domain d is *stronger* than a domain d
′, written d ⊆ d
′, if and only if d(x) ⊆ d
′(x)
for all x ∈ X. A domain d is *strictly stronger* than a domain d
′, written d ⊂ d
′, if and