# A Cognitive Mind-Map Framework To Foster Trust

Jayanta Poray, Christoph Schommer

![0_image_0.png](0_image_0.png)

Dept. of Computer Science and Communication ILIAS Laboratory - MINE Research Group University of Luxembourg L-1359 Luxembourg, Luxembourg

## Abstract

The explorative mind-map is a dynamic framework, that emerges automatically from the input, it gets. It is unlike a verificative modeling system where existing (human)
thoughts are placed and connected together. In this regard, explorative mind-maps change their size continuously, being adaptive with connectionist cells inside; mind-maps process data input incrementally and offer lots of possibilities to interact with the user through an appropriate communication interface. With respect to a cognitive-motivated situation like a conversation between partners, mind-maps become interesting as they are able to process stimulating signals whenever they occur. If these signals are close to an own understanding of the world, then the conversational partner becomes automatically more trustful than if the signals do not or less match the own knowledge scheme. In this
(position) paper, we therefore motivate explorative mindmaps as a cognitive engine and propose these as a decision support engine to foster trust.

## 1. Explorative Mind-Maps

The principles of explorative mind-maps Mi have already been described in [11], where we accent that mind-maps rely on the natural principle on sensations and the corresponding propagation of stimuli to a final destination. Indeed, explorative mind-maps share this principle through an associative architecture that incrementally processes accepted stimuli to a consistent informational structure. This is similar to the natural paradigm, but on contrast to a verificative processing of a user's thoughts, the explorative mind-maps are built from the bottom up, meaning that their existence exclusively interdepend on incoming signals.

Explorative mind-maps share a sub-symbolic architecture that is composed of interacting entity cells ei. As mentioned above for the natural principle, these cells foster on a processing of data streams and a stimulation/inhibitionprinciple of adjacent connections. The activation of such a connectionist architecture bases on a dynamic construction of cell structures during the processing of the input stream.

In the *stimulation phase*, a stream data is stimulated and absorbed by *receptor (input) cells* ri, which decompose the stream to its entities. For example, the text streams are decomposed into the word entities, transactional streams to item entities, and so on. Using *filter cells* fi, those receptor cells ri are inhibited that do not address a semantic interest.

In the *Mini-Network phase*, the collection of entities, which occur at such a specific time-point, form a mini-network
[6] with fully connected mini-network cells mi. The *Mindmap Merger* starts once the mini-network is established:
in this phase, the mini-network is sent to the mind-map and is merged with the existing entity cells in the mindmap (initially, the mind-map is empty). In this regard, the specified merge references an action of mini-network and entity cells (mi and ei) - that share a same representation - to a unique entity cell. The activation status act(ei) of an entity cell is then increased, in case it has been merged.

If two adjacent entity cells ek and el of the mind-map are activated by the mini-network at the same time, their connection weight ω(ek, el) is increased by a learn rate φ
(Hebbian Learning). If two adjacent entity cells remain inactivated, their connection weight is decreased by a fragment