expected progression. Furthermore, we understand trust as the result of an existing reliable, authentic and confident status, which follows from a representation of the current internal knowledge (belief), the state of personal emotion and associated interest. As mention in [2] and [3], the individual decision (to trust or not) is additionally governed by a host of factors like past experiences, history of events, others' opinion and socio-cognitive behavior.

## 2.2. When Alice Converses With Bob

The trust between two persons is considered as the measure of a mutual belief. How to define the appropriate trust opinion during a conversation is a matter of concern.

Assume that two natural persons *Alice* and Bob talk to each other where both may decide if an incoming conversational signal is considered as worth to remember or even not. Also if textual patterns inside the conversational streams are to be extracted, summarized and kept in mind - or even handled as noise. If both *Alice* and Bob store conversational signals inside a knowledge-based representation framework, then Alice will know something (or something more) about Bob and vice versa. After receiving the input signal from Bob, Alice surely develops some certain belief about Bob and his believes - at least with respect to the subject of conversation
(and vice versa). Moreover, we may follow the idea that both are able to match their own mind-maps (representation of what each of them thinks) against the mind-maps of the conversing partner: both may decide at any time if they trust, and if yes, up to which level.

## 3. A First Approach

To realize such mind-maps, however, we need a strategy to concern with the raw data input. To filter out stop-words and to morphologically reduce a word to its root seems to be manageable by the inclusion of a thesaurus or a dictionary.

Also the concern with typical natural language problems like the occurrence of anaphors or the ambiguity of word senses - in both cases, we must find the corresponding entity
- are problems of larger consequences. Presently, we pay no attention to it but set it back thereinafter. Earnestly, we presently ask for the calculation of the match while only figuring out an existing mind-map. We are aware that a trust function must take into account a temporal stamp, because the trust decision may be revised every time.

## 3.1. Constituting Two Mind-Maps

We claim that each person who converses must have
(at least) two independent mind-maps Mp and M∗
pq that affect both an individual understanding about his/her own world (Mp) and some estimations about the world of the conversing partner (M∗
pq). Actually Mp is a fixed wired system that includes own beliefs, emotions, etc. (firstly in a word-related representation that is built by words) and also M∗
pq is the own representation of the conversing partner ,
strictly speaking, of the related words within a conversation.

With regard to this, a person's trust is obtained if the own representation of the conversing partner M∗
pq is fully consistent with the own mind-map Mp. On the other side, a person may not agree to the conversing partner if the gap between the matching mind-maps get too wide.

In case that a person p converses with two persons, namely q and r, corresponding mind-maps (for the outer world) M∗
pq and M∗
pr will be created for maintain individual conversational view. Most of the real time conversational applications are supported by this model, where p needs to converse with a group of persons at the same time.

## 3.2. Gtrust**: A Suggestive Matching Function**

In a naive approach, the decision of trusting another person may depend on the number of entity cells that is in Mp and M∗
pq. Here two mind-maps are called similar, if final number of matching entity cells reaches certain threshold value. This degree of similarity exactly defines the trustworthiness of p for the conversational partner q.

Furthermore, an improved version of this naive approach, however, is to take into account the activation status (and the corresponding connection status). The similarity between the two mind-maps Mp and M∗
pq is then not only the pure number of common entity cells but moreover a weighted sum.

The advantage of such an approach is that all nodes of the mind-map are used with the identical privilege. The disadvantage is that keywords or key statements are not focused on adequately. Another suggestion therefore is to select only k entity cells with the highest frequency - or the other way around - those entity cells with the lowest frequency (assuming that less occurring words are more interesting than others). Alternatively, we may sample the entity cells to select randomly selected nodes.

All strategies are worth to become applicable, but often a person typically owns a number of entities that are highly important whereas other entities - although being important
- remain negligible. An example hereby is the color of a car, which is in many cases one of the KO criterions
(to a woman) but even less important than the amount of horsepowers (to a man). We therefore appeal to arrange an individual *parallel universe*, which consists of entity cells with corresponding self-relevance ρMp (ei, t) for its own entity cell ei and the *outer-relevance* ρ M∗
pq (ej , t) for the entity cell ej , achieved from the conversational partner q. Each relevance value is dynamic and may change over time t, being strong or weak: the strongest entity cells then resemble to neural attractors, the weakest cells to "fellowrunners".