Definition 7 (Atomic Preference Formula (APF))
Let V *be a totally ordered set with minimal element* vmin *and maximal element* vmax*. An atomic preference formula is a formula*
ϕ0[v0] ≫ ϕ1[v1] ≫ ... ≫ ϕn[vn], where each ϕi *is a BDF, each* vi ∈ V, vi < vj for **i < j***, and* v0 = vmin*. When* n = 0, atomic
preference formulae correspond to BDFs.
While one could let V = [0, 1], you could choose a strictly
qualitative set like {best < good < indifferent < bad < worst} to express preferences over alternatives.
Now here are a few APF examples from the travel domain.
P2[0] ≫ **apply**′(*by-car-local(SUV, National)*)[0.3] (P8)
apply′(*by-car-trans*)[0] ≫ **apply**′(*by-flight*)[0.4] (P9)
occ
′
(*book-train*)[0] ≫ occ
′
(*book-car*)[0.4] (P10)
P8 states that the user prefers that the *by-car-local* method
rents an SUV and that the rental car company Avis is preferred to National. P9 states that the user prefers to decompose the *arrange-trans* task by the method *by-car-trans*
rather than the *by-flight* method. Note that the task is implicit in the definition of the method. P10 states that the user
prefers travelling by train over renting a car.
To allow the user to specify more complex preferences
and to aggregate preferences, General Preference Formulae (GPFs) extend the language to conditional, conjunctive, and
disjunctive preferences. Definition 8 (General Preference Formula (GPF))
A formula Φ *is a GPF if one of the following holds:*
- Φ *is an APF* - Φ is γ : Ψ, where γ is a BDF and Ψ *is a GPF [Conditional]*
- Φ *is one of* Ψ0 & Ψ1 & ... & Ψn [General Conjunction]
or Ψ0 | Ψ1 | ... | Ψn [General Disjunction]
where n ≥ 1 and each Ψi *is a GPF.*
General conjunction (resp.general disjunction) refines the
ordering defined by Ψ0 & Ψ1 & ... & Ψn (resp. Ψ0|Ψ1|...|Ψn) by sorting indistinguishable states using the lexicograping ordering. Continuing our example:
occ(*arrange-trans*) : (∃c).occ
′
(*book-car*(**c, Avis**)) (P11)
occ(*arrange-local-trans*) : P1 (P12)
drivable : P10[0] ≫ occ
′
  **Acknowledgments**  I would like to thank my supervisor, for his kind of support. I would like to thank my supervisor, for his kind of support.  

## P4 & P6& P7& P8 & P9 & P10 & P12 & P13 (P14)
P11 States That If Inter-City Transportation Is Being Arranged Then The User Prefers To Rent A Car From Avis. P12
States That If Local Transportation Is Being Arranged The User
Prefers Enterprise. P13 States That If The Distance Between The Origin And The Destination Is Drivable Then The User Prefers To
Book A Train Over Booking A Car Over Booking A Flight. P14 Aggregates Preferences Into One Formula.
Again, And Only For The Purpose Of Proving Properties, We
Provide An Encoding Of The Htn-Specific Terms Of Lph In
The Situation Calculus. As Such, For Any Preference Formula
Φhtn There Is A Corresponding Formula Φsc Where Every
Htn-Specific Term Is Replaced As Follows: Each Literal L Is
Mapped To A Fluent Or Non-Fluent Relation In The Situation Calculus, As Appropriate; Each Primitive Task T Is Mapped To An
Action A ∈ A; And Each Nonprimitive Task T And Each Method
M Is Mapped To A Procedure P(~V) ∈ R In Congolog. 3.1 The Semantics

The semantics of LPH is achieved through assigning a
weight to a situation s with respect to a GPF, Φ, written
ws(Φ). This weight is a composition of its constituents. For BDFs, a situation s is assigned the value vmin if the BDF is
satisfied in s, vmax otherwise. Similarly, given an APF, and
a situation s, s is assigned the weight of the best BDF that it
satisfies within the defined APF. Finally GPF semantics follow the natural semantics of boolean connectives. As such
General Conjunction yields the minimum of its constituent
GPF weights and General Disjunction yields the maximum.
Similar to (Gabaldon 2004) and following LPP, we use
the notation ϕ[s
′, s] to denote that ϕ holds in the sequence
of situations starting from s
′and terminating in s. Next, we
will show how to interpret BDFs in the situation calculus.
If f is a fluent, we will write f[s
′
, s] = f[s
′
] since fluents are represented in situation-suppressed form. If r is
a non-fluent, we will have r[s
′, s] = r since r is already
a situation calculus formula. Furthermore, we will write
final(f)[s
′, s] = f[s] since **final**(f) means that the fluent
f must hold in the final situation.
The BDF occ(X) states the occurrence of X which can
be either an action or a procedure. written as:
be either an action of a procedure. written as:  $$\mathbf{occ}(X)[s^{\prime},s]=\left\{\begin{array}{ll}do(X,s^{\prime})\sqsubseteq s&\mbox{if$\mathbf{X}\in\mathcal{A}$}\\ do(start(X),s^{\prime})\sqsubseteq s&\mbox{if$\mathbf{X}\in\mathcal{R}$}\end{array}\right.$$  The BDF **apply**$(P(\vec{v}))$ will be interpreted as follows:  $$\mathbf{apply}(P(\vec{v}))[s^{\prime},s]=do(start(P(\vec{v})),s^{\prime})\sqsubseteq s$$
Boolean connectives and quantifiers are already part of the
situation calculus and require no further explanation here. The LTL constructs are interpreted in the same way as in
(Gabaldon 2004). We interpret the rest of the connectives as
follows 2.
before(X1, X2)[s
′
, s] = (∃s1, s2 : s
′ ⊑ s1 ⊑ s2 ⊑ s)
{*terminated*(X1)[s1] ∧ ¬*executing*(X2)[s1] ∧ ¬*terminated*(X2)[s1] ∧ occ(X2)[s2, s]}
holdBefore(**X, f**)[s
′
, s**] = (**∃s1 : s
′ ⊑ s1 ⊑ s)
{f[s1] ∧ occ(X)[s1, s]}
holdAfter(**X, f**)[s
′
, s**] = (**∃s1 : s
′ ⊑ s1 ⊑ s)
{**terminated**(X)[s1] ∧ f[s1]}
holdBetween(X1**, f, X**2)[s
′
, s] =
(∃s1, s2 : s
′ ⊑ s1 ⊑ s2 ⊑ s)
{*terminated*(X1)[s1] ∧ ¬*executing*(X2)[s1] ∧ ¬*terminated*(X2)[s1] ∧ occ(X2)[s2, s]} ∧ (∀si : s1 ⊑ si ⊑ s2)f[si]
From here, the semantics follows that of LPP.

Definition 9 (Basic Desire Satisfaction) Let D *be an action theory, and let* s
′
and s *be situations such that* s
′ ⊑ s. The situations beginning in s
′
and terminating in s satisfy ϕ *just in the case that* D |= ϕ[s
′
, s]. We define ws′ ,s(ϕ) to be the weight of the situations originating in s
′
and ending in s *wrt BDF* ϕ. ws′,s(ϕ) = vmin if ϕ *is satisfied, otherwise* ws′ ,s(ϕ) = vmax.

Note that for readability we are going to drop s
′from the index, i.e., ws(ϕ) = ws
′
,s(ϕ) in the special case of s
′ = S0.