

![0_image_3.png](0_image_3.png)

neighbours ← **EXPAND**(w, D, partialP, s, progPref)
frontier ← SORTN**MERGE**(neighbours, *frontier*)
return [], ∞
Figure 1: A sketch of the **HTNPREF** algorithm.

![0_image_4.png](0_image_4.png)

pessW, and *pref* corresponding to the progression and evaluation of the input preference formula in the initial state.

On each iteration of the **while** loop, **HTNPREF** removes the first node from the frontier and places it in *current*. If w is empty (i.e., U is an empty set), the situation associated with this node is a terminating situation. Then **HTNPREF** returns *current*'s partial plan and weight. Otherwise, it calls the function **EXPAND** with *current's* node as input.

EXPAND returns a new list of nodes that need to be added to the frontier. The new nodes are sorted by optW, pessW, and merged with the remainder of the frontier. If w is nil then the frontier is left as is. Otherwise, it generates a new set of nodes of the form [optW, *pessW*,
newW, newPartialP, newS, *newProgPref*], one for each legal ground operator that can be reached by performing w using a partial-order forward decomposition procedure
(PFD) (Ghallab, Nau, and Traverso 2004). Currently HT-**NPREF** uses **SHOP**2 (Nau et al. 2003) as its PFD. Hence, the current implementation of **HTNPREF** is an implementation of **SHOP**2 with user preferences. For each primitive task leading to terminating states, **EXPAND** generates a node of the same form but with *optW* and *pessW* replaced by the actual weight. If we reach the empty frontier, we return the empty plan.

## Theorem 2 (Soundness And Optimality)

Let P=(s0**, w, D,** Φ) be a HTN planning problem with user preferences. Let π *be the plan returned by* **HTNPREF** *from input* P.

Then π *is a solution to the preference based HTN problem* P
Proof sketch: We prove that the algorithm terminates appealing to the fact that the PFD procedure is sound and complete.

We prove that the returned plan is optimal, by exploiting the correctness of progression of preference formula, and admissibility of our evaluation function.

## 5.1 Experiments

We implemented our preference-based HTN planner, HTNPREF, on top of the LISP implementation of SHOP2 (Nau et al. 2003). All experiments were run on a Pentium 4 HT, 3GHZ CPU, and 1 GB RAM, with a time limit of 900 seconds. Since the optimality of **HTNPREF**generated plans was established in Theorem 2, our objective was to evaluate the effectiveness of our heuristics in guiding search towards the optimal plan, and to establish benchmarks for future study, since none currently exist.

We tested **HTNPREF** with ZenoTravel and Logistics domains, which were adapted from the International Planning

| P                     | SHOP2   | HTNPREF   |       |      |      |       |    |
|-----------------------|---------|-----------|-------|------|------|-------|----|
| #                     | # Plan  | NE        | Time  | NE   | NC   | Time  | PL |
| 1                     | 12      | 172       | 0.54  | 79   | 89   | 1.71  | 23 |
| 2                     | 19      | 224       | 2.41  | 72   | 78   | 2.2   | 30 |
| 3                     | 155     | 1629      | 14.47 | 160  | 188  | 5.71  | 30 |
| 4                     | 204     | 2287      | 19.58 | 53   | 59   | 0.84  | 29 |
| 5                     | 230     | 2235      | 9.13  | 362  | 414  | 7.75  | 24 |
| 6                     | 230     | 2235      | 9.13  | 77   | 24   | 1.67  | 24 |
| 7                     | 485     | 6332      | 64.24 | 241  | 277  | 13.58 | 39 |
| 8                     | 487     | 6227      | 109.9 | 122  | 125  | 13.8  | 46 |
| 9                     | 720     | 6725      | 45.62 | 212  | 251  | 7.96  | 32 |
| 10                    | 4491    | 45612     | 492.1 | 2154 | 2923 | 128.1 | 36 |
| 11                    | >1522   | >16K      | >900  | 145  | 155  | 11.34 | 58 |
| 12                    | >2156   | >24K      | >900  | 1680 | 1690 | 238.1 | 50 |
| (a) ZenoTravel domain |         |           |       |      |      |       |    |
| P                     | SHOP2   | HTNPREF   |       |      |      |       |    |
| #                     | # Plan  | NE        | Time  | NE   | NC   | Time  | PL |
| 1                     | 8       | 109       | 0.28  | 32   | 34   | 0.44  | 28 |
| 2                     | 90      | 540       | 1.01  | 20   | 25   | 0.24  | 13 |
| 3                     | 92      | 497       | 0.41  | 18   | 20   | 0.16  | 14 |
| 4                     | 808     | 4597      | 6.01  | 302  | 405  | 3.47  | 19 |
| 5                     | 920     | 4310      | 5.22  | 74   | 94   | 1.01  | 15 |
| 6                     | 1260    | 6320      | 6.58  | 131  | 173  | 1.48  | 15 |
| 7                     | 2178    | 15104     | 26.18 | 28   | 33   | 0.39  | 21 |
| 8                     | 2520    | 14728     | 20.07 | 30   | 41   | 0.56  | 17 |
| 9                     | >35K    | >236K     | >900  | 38   | 49   | 0.65  | 25 |
| 10                    | >39K    | >153K     | >900  | 905  | 1246 | 22.0  | 21 |
| 11                    | >40K    | >156K     | >900  | 1K   | 1438 | 20.1  | 20 |
| 12                    | >42K    | >230K     | >900  | 452  | 619  | 7.88  | 23 |
| (b) Logistic domain   |         |           |       |      |      |       |    |

![0_image_0.png](0_image_0.png)

![0_image_1.png](0_image_1.png)

![0_image_2.png](0_image_2.png)

Figure 2: Our criteria for comparisons are number of Nodes Expanded (NE), number of applied operators; number of Nodes Considered (NC), the number of nodes that were added to the frontier, and time measured in seconds. Note NC is equal to NE for **SHOP**2. PL is the Plan Length and \# Plan is the total number of plans.

Competition (IPC). The ZenoTravel domain involves transporting people on aircrafts that can fly at two alternative speeds between locations. The Logistics domain involves transporting packages to different destinations using trucks for delivery within cities and planes for between cities.

In order to evaluate the effectiveness of **HTNPREF** it would have been appealing to evaluate our planner with a preference-based planner that also makes use of procedural control knowledge. But since no comparable planner exists, and it would not have been fair to compare **HTNPREF** with a preference-based planner that does not use control knowledge, we compared **HTNPREF** with **SHOP**2, using a bruteforce technique for **SHOP**2 to determine the optimal plan. In particular, as is often done with Markov Decision Processes, SHOP2 generated all plans that satisfied the HTN specification and then evaluated each to find the optimal plan. Note that the times reported for **SHOP**2 do not actually include the time for posthoc preference evaluation, so they are lower bounds on the time to compute the optimal plan.

Figure 2 reports our experimental results for ZenoTravel and the Logistics domain. The problems varied in preference difficulty and are shown in the order of difficulty with respect to number of possible plans (\# Plan) that satisfy the