HTN control.

The results show that, in all but the first case of each domain, **SHOP**2 required more time to find the optimal plan, and expanded more nodes. In particular note that in problems 11 and 12 **SHOP**2 ran out of time (900 seconds) while HTNPREF found the optimal plan well within the time limit.

Also note that **HTNPREF** expands far fewer nodes in comparison to **SHOP**2, illustrating the effectiveness of our evaluation function in guiding search.

## 6 Summary And Related Work

In this paper, we addressed the problem of generating preferred plans by combining the procedural control knowledge of HTNs with rich qualitative user preferences. The most significant contributions of this paper include: LPH,
a rich HTN-tailored preference specification language, developed as an extension of a previously existing language; an approach to (preference-based) HTN planning based on forward-chaining heuristic search, that exploits progression to evaluate the satisfaction of preferences during planning; a sound and optimal implementation of an ordered-taskdecomposition preference-based HTN planner; and leveraging previous research, an encoding of HTN planning with preferences in the situation calculus, that enabled us to prove our theoretical results. While the implementation we present here exploits **SHOP**2, the language and techniques proposed are relevant to a broad range of HTN planners.

In previous work, we addressed the problem of integrating user preferences into Web service composition
(Sohrabi, Prokoshyna, and McIlraith 2006). To that end, we developed a Golog-based composition engine that also exploits heuristic search. It similarly uses an optimistic heuristic. The language used in that work was LPP and had no Web-service or Golog-specific extensions for complex actions. This paper's HTN-tailored language and HTN-based planner are significantly different.

Preference-based planning has been the subject of much interest in the last few years, spurred on by an International Planning Competition (IPC) track on this subject. A number of planners were developed, all based on the the competition's PDDL3 language (Gerevini and Long 2005). Our work is distinguished in that it exploits *procedural* (actioncentric) domain control knowledge in the form of an HTN,
and action-centric and state-centric preferences in the form of LPH. In contrast, the preferences and domain control in PDDL3 and its variants are strictly state-centric. Further, LPH is *qualitative* whereas PDDL3 is quantitative, appealing to a numeric objective function. We contend that qualitative, action- or task-centric preferences are often more compelling and easier to elicit that their PDDL3 counterparts.

While no other HTN planner can perform true preference-based planning, **SHOP**2 (Nau et al. 2003) and ENQUIRER (Kuter et al. 2004) handle some simple user constraints. In particular the order of methods and sorted preconditions in a domain description specifies a user preference over which method is more preferred to decompose a task. Hence users may write different versions of a domain description to specify simple preferences. However, unlike **HTNPREF** the user constraints are treated as hard constraints and (partial) plans that do not meet these constraints will be pruned from the search space. Further, there is no way to handle temporally extended hard or soft constraints in **SHOP**2. We used progression in our approach to planning precisely to deal with these interesting preferences. Were we limiting the expressive power of preferences to **SHOP**2-like method ordering, we would have created a different planner.

Interestingly, **SHOP**2 method ordering can still be exploited in our approach, but requires a mechanism that is beyond the scope of this paper.

Finally, the **ASPEN** planner
(Rabideau, Engelhardt, and Chien 2000) performs a simple form of preference-based planning, focused mainly on preferences over resources and with far less expressivity than LPH. Nevertheless, **ASPEN** has the ability to plan with HTN-like task decomposition, and as such, this work is related in spirit, though not in approach to our work. Acknowledgements: We gratefully acknowledge funding from the Natural Sciences and Engineering Research Council of Canada (NSERC) and the Ontario Ministry of Research and Innovation Early Researcher Award.

## References

[Bienvenu, Fritz, and McIlraith 2006] Bienvenu, M.; Fritz, C.; and McIlraith, S. A. 2006. Planning with qualitative temporal preferences. In *Proceedings of the 10th International Conference on Knowledge Representation and Reasoning (KR)*, 134–144.

[De Giacomo, Lesp´erance, and Levesque 2000] De Giacomo, G.; Lesp´erance, Y.; and Levesque, H. 2000.

ConGolog, a concurrent programming language based on the situation calculus. *Artificial Intelligence* 121(1–
2):109–169.

[Gabaldon 2002] Gabaldon, A. 2002. Programming hierarchical task networks in the situation calculus. In *AIPS'02* Workshop on On-line Planning and Scheduling.

[Gabaldon 2004] Gabaldon, A. 2004. Precondition control and the progression algorithm. In Proceedings of the 9th International Conference on Knowledge Representation and Reasoning (KR), 634–643. AAAI Press.

[Gerevini and Long 2005] Gerevini, A., and Long, D.

2005. Plan constraints and preferences for PDDL3. Technical Report 2005-08-07, Department of Electronics for Automation, University of Brescia, Brescia, Italy.

[Ghallab, Nau, and Traverso 2004] Ghallab, M.; Nau, D.;
and Traverso, P. 2004. *Hierarchical Task Network Planning. Automated Planning: Theory and Practice*. Morgan Kaufmann.

[Kuter et al. 2004] Kuter, U.; Sirin, E.; Nau, D. S.; Parsia, B.; and Hendler, J. A. 2004. Information gathering during planning for web service composition. In Proceedings of the 3rd International Semantic Web Conferece (ISWC), 335–349.

[Nau et al. 2003] Nau, D. S.; Au, T.-C.; Ilghami, O.; Kuter, U.; Murdock, J. W.; Wu, D.; and Yaman, F. 2003. SHOP2: