# Assessing The Impact Of Informedness On A Consultant'S Profit

Eugen Staab and Martin Caminada University of Luxembourg
{eugen.staab,martin.caminada}@uni.lu

## Abstract

We study the notion of informedness in a client-consultant setting. Using a software simulator, we examine the extent to which it pays off for consultants to provide their clients with advice that is well-informed, or with advice that is merely meant to appear to be well-informed. The latter strategy is beneficial in that it costs less resources to keep up-to-date, but carries the risk of a decreased reputation if the clients discover the low level of informedness of the consultant. Our experimental results indicate that under different circumstances, different strategies yield the optimal results (net profit) for the consultants. Keywords: well-informedness, argumentation, social simulation.

## 1 Introduction

When purchasing information, one wants to be sure of the quality of the information in question. However, if one is not an expert oneself in the relevant domain, assessing the quality of information can be difficult. For the sellers of information (which we will simply refer to as "the consultants") this provides an incentive for dishonesty. After all, gaining real expertise costs significant efforts as well as time and money. However, if the consumer of information (which we will refer to as "the client") has difficulties assessing the quality of the provided information, then why not pretend to have a higher level of expertise than one actually has? As long as the chance that the client detects this dishonesty is low, a consultant can charge the same price for his advice, yet spend less resources on maintaining up-to-date of the state of the art. Moreover, the more consultants decide to take it easy, the less likely it is that the clients will find out about it. This is because once a critical mass of consultants gives ill-informed advice, it becomes more and more difficult for the clients to obtain the kind of well-informed advice that they need in order to detect the ill-informedness of the other advice. This implies that once a critical mass of low expertise consultants has become established, the incentive for consultants to take it easy will increase, since the chance of discovery has decreased.

The issue of low quality information has been studied in [8, 5]. What is new, however, is that we have now developed a software simulator that is able to assess the pay-off for the consultants of either a strategy of hard work or a strategy of taking it easy when it comes to staying up to date with the state of the art. In particular, we are able to provide qualitative insight on which strategy yields the most profitable results under which circumstances.