
## 2 Argumentation And Informedness

The aim of this section is to examine how argumentation can play a role to examine the concept of informedness, which can be seen as background theory for the remaining, more practical part of this paper.

In standard epistemic logic (S5), informedness is basically a binary phenomenon. One either has knowledge about a proposition p or one does not. It is, however, also possible to provide a more subtle account of the extent to which one is informed about the validity of proposition p. Suppose Alex thinks that Hortis Bank is on the brink of bankruptcy because it has massively invested in mortgage backed securities. Bob also thinks that Hortis is on the brink of bankruptcy because of the mortgage backed securities. Bob has also read an interview in which the finance minister promises that the state will support Hortis if needed. However, Bob also knows that the liabilities of Hortis are so big that not even the state will be able to provide significant help to avert bankruptcy. From the perspective of formal argumentation [7], Bob has three arguments at his disposal.

A: Hortis Bank is on the brink of bankruptcy, because of the mortgage backed securities.

B: The state will save Hortis, because the finance minister promised so. C: Not even the state has the financial means to save Hortis.

Here, argument B attacks A, and argument C attacks B (see eq. 1). In most approaches to formal argumentation, arguments A and C would be accepted and argument B would be rejected.

A ←− B ←− C (1)
Assume that Alex has only argument A to his disposal. Then it seems to regard Bob as more informed with respect to proposition p ("Hortis Bank is on the brink of bankruptcy") since he has a better knowledge of the facts relevant for this proposition and is also in a better position to defend it in the face of criticism.

The most feasible way to determine whether someone is informed on some given issue is to evaluate whether he is up to date with the relevant arguments and is able to defend his position in the face of criticism. One can say that agent X is more informed than agent Y if it has to its disposal a larger set of relevant arguments.

We will now provide a more formal account of how the concept of informedness could be described using formal argumentation. An *argumentation framework* [7] is a pair (Ar , att)
where Ar is a set of arguments and att is a binary relation on Ar . An argumentation framework can be represented as a directed graph. For instance, the argumentation framework
({A, B, C}, {(C, B),(*B, A*)}) is represented in eq. 1.

Arguments can be seen as defeasible derivations of a particular statement. These defeasible derivations can then be attacked by statements of other defeasible derivations, hence the attack relationship. Given an argumentation framework, an interesting question is what is the set (or sets) of arguments that can collectively be accepted. Although this question has traditionally been studied in terms of the various fixpoints of the characteristic function [7], it is equally well possible to use the approach of argument labelings [2, 4, 6]. The idea is that each argument gets exactly one label (accepted, rejected, or abstained), such that the result satisfies the following constraints.

1. If an argument is labeled accepted then all arguments that attack it must be labeled rejected.