costs per piece of information; in our case, this information comes in the form of arguments as we will see later. The more clients request a certain consultant's advice, the lower his price for a consultation can be. Note that this actually explains why the intermediary role of consultants exists.

Clients are free to choose their consultant, and so select in each round the consultant that they think is currently the most appropriate one. In our simulations, this selection is based on price and reputation of the consultants as it will be detailed later.

## 3.1.2 Argumentation Framework

We consider the following argumentation structure consisting of Narg many arguments:

$$A_{1}\longleftarrow A_{2}\longleftarrow\ldots\longleftarrow A_{N_{\mathrm{arg}}}\;.$$
$\left(2\right)^3$

A1 ←− A2 ←− *. . .* ←− ANarg . (2)
7
Here, any argument Ai (for 1 < i ≤ Narg) defeats its predecessor argument Ai−1. If Narg is even, then all arguments Ai where i is even, are "in", and all other arguments are "out". If Narg is odd, it is the other way around.

At the beginning of a simulation, only argument A1 is known to the consultants and only this argument is known in the whole society, i.e. it represents the "state of the art". To model the discovery/emergence of new information, we make a certain number of new arguments available to the consultants in each round. This represents the evolution of the state of the art. The number of new arguments per round will be fixed for a simulation and is denoted by ∆Narg. We assume that the consultants extend their already known chain of arguments with new arguments always in a seamless manner, i.e. without gaps. This assumption was made in order to be in line with argument games (such as described in [9, 11, 1]) where each uttered argument is a reaction to a previously uttered argument, thus satisfying the property of *relevance* [3].

For a better understanding, the following shows the structure of the chain of arguments at any round of the simulation (k ≤ i must hold):

"state of the art" z }| { A1 ←− . . . ←− Ak | {z } known to certain consult. ←− . . . ←− Ai ←− becoming available next round z }| { Ai+1 ←− . . . ←− Ai+∆Narg ←− . . . ←− ANarg . (3)
Consultants generally want to provide the least amount of information needed for a consultation, because this way they can give more consultations. However, consultants generally want to give good advice at the same time, to increase their reputation. We assume that consultants believe that the latest argument they know is the most justified one, because it is closest to the current state of the art. As a consequence, in order to give good advice, they only consult arguments that are compliant to the latest argument they possess, i.e. arguments whose index has the same parity as the latest argument they know. To provide the least amount of information at the same time, a rational consultant acts as follows: he provides the client with two arguments, if the latest argument known to the client is of the same parity as the latest argument known to the consultant, and with one argument otherwise. The latest argument known to the client is updated accordingly.

To keep things simple, the cost of an argument is set to a constant carg. So, to get the knowledge about argument A10, the consultant has an overall expense of 10 · carg (recall that arguments can only be acquired in a row). We write narg to denote the total number