of arguments acquired by a specific consultant (where narg ≤ Narg). Thus, we model the expenses E of a consultant as:

$$E=n_{\mathrm{arg}}\cdot c_{\mathrm{arg}}\ .$$
$$(4)$$
E = narg · carg . (4)

## 3.1.3 Strategies Of The Consultants

We consider two types of consultants that deal differently with newly available arguments:
well-informed (wi ): wi-consultants buy arguments as soon as these become available, since they want to be always up-to-date.

ill-informed (ii ): ii-consultants only buy arguments as to appear knowledgeable to the clients. That is, as soon as they notice that a client is as informed as they are, or even better informed, they buy a number of new arguments such that they know one argument more than this client.

Clearly, ii-consultants can offer their consultations at a lower price. However, the reputation of a consultant decreases with each consultation where the client turns out to be as informed as the consultant - and this happens more often to ii-consultants.

The turnover of a consultant is defined by the sum of prices the consultant was paid. Let S
be the multiset enumerating all prices paid by clients up to a certain round. So, S represents the consultations where the consultant actually was better informed than the client, and thus was paid. Then the turnover T up to this point is defined as:

$$T=\sum_{p\in S}p\;.$$
$$\left({\mathfrak{h}}\right)$$
(G) $\frac{1}{2}$
p . (5)
Finally, the profit P of a consultant up to a certain round is the difference between his turnover and his expenses so far:

$$P=T-E\ .$$
P = T − E . (6)

## 3.1.4 Selection Of A Consultant

In our simulations, clients rate consultants according to two criteria: the consultant i's current reputation ri and price pi. The two criteria are explained in more detail later in this section.

For now, it suffices to know that they are normalized to [0, 1]. To make both parameters
"positive", the price pi will be expressed in the form of *cheapness* ci, i.e., ci = 1 − pi. This way, both a *high* cheapness and a *high* reputation characterize a good consultant. A parameter α ∈ [0, 1] defines which of the two criteria a client thinks is more important. Consequently, a client chooses consultant i with a probability proportional to:

$$P_{i}:=\alpha\cdot c_{i}+(1-\alpha)\cdot r_{i}\ .$$
Pi:= α · ci + (1 − α) · ri. (7)
A high α favors the choice of cheaper consultants, while a low α favors the choice of more reputable consultants.

$\left(7\right)$. 