# A Multiagent Urban Traffic Simulation Part I: Dealing With The Ordinary

Pierrick Tranouez, Patrice Langlois, Éric Daudé Abstract— We describe in this article a multiagent urban traffic simulation, as we believe individual-based modeling is necessary to encompass the complex influence the actions of an individual vehicle can have on the overall flow of vehicles. We first describe how we build a graph description of the network from purely geometric data, ESRI shapefiles. We then explain how we include traffic related data to this graph. We go on after that with the model of the vehicle agents: origin and destination, driving behavior, multiple lanes, crossroads, and interactions with the other vehicles in day-to-day, "ordinary" traffic. We conclude with the presentation of the resulting simulation of this model on the Rouen agglomeration.

Index Terms— multiagent systems, traffic simulation, 

## Geomatics, Multiscale I. Introduction

I
F traffic modeling is nearing a century of age, most of these models belong to Operational Research problems - finding an optimal solution balancing various constraints. In these models, roads and road users were abstracted and aggregated, so as to become a flow problem that could then be optimized. They can answer interesting questions in urban or public transport planning [1].

Sometimes considering average response to a problem is not enough for the scientific problem at hand. We are interested in a dynamic modeling of urban traffic. In this kind of problem, the actions of a few can have a definite impact on the global traffic. An accident implicating half a dozen vehicles in a strategic crossroads of a town can create a traffic jam wave that can affect thousand vehicles. This is the kind of complex phenomenon we would like to be able to model and simulate. Classic OR tools aren't well suited to the task.

Although we aren't the first to make this statement [2,3], 
models that tried to alleviate this too-large-scale limitation, have mainly tried to use cellular automata for the task. They added some level of individual-based components to their modeling, but still failed to encompass all that could be needed. Cellular automata are eulerian methods - intelligence is in one place, rules describe the behavior of bits of space. 

Values linked to the cells seem to simulate the entities of the modeled system, the same way alternatively lit crystals in an LCD display can give the illusion an object moves around a screen. This contrasts with lagrangian descriptions, where entities of an environment are distinguished, and their spatial coordinates are but one of their describing characteristics. 

Unlike what can be easily simulated in a CA, lagrangian entities have a *trajectory*: even in a discretized space a la CA, they can for example act according to something that happened n time steps and m space steps before or away, or according to a plan. This can't *practically1* be done in a CA. 

Multiagent systems belong to this latter category of modeling. As we try to build a model with a grain fine to the level of geometrically correct individual vehicle behavior, from which at least town-quarters-level flow disturbance can arise, we believe this technique is the right one for the task.

## Ii. From Geometry To Topology A. Geographical Databases

A Geographical Information System is a system designed for creating, storing, analyzing and managing spatial data and associated attributes. Although it contains a relational database, it needs to go beyond what is needed for classical alphanumerical databases to manage geometrical information, which is continuous by nature, as opposed to the discreteness of usual databases. Indeed for example the database cannot contain all the points of two segments in order to compute a possible intersection: other storing and managing methods must be used for the geometric data of the system.

A geographic database is generally comprised of layers or coverage overlapping on a same spatial domain. Each layer contains homogeneous spatial features such as the limits of a city, the course of a river, the geometry of a road etc. Each feature is described in two different ways. First the geometric and optionally topological information is stored in different binary files in the base. Second the record description is a line in the record table; it contains different attributes and descriptions of the feature (generally text or numbers).

## B. Esri Shapefiles

The first step of the constitution of our system is the constitution of a basic layer of geographic database. This layer is built from the importation of *shapefiles*, a GIS file format popularized by ESRI [4]. In order to build a traffic simulation, 