accelerate and brake, the taste of its driver for long/short safety distance, its taste for following or breaking speed limits etc. All this is incorporated in a driving model inspired by Martin Treiber's Intelligent Driver Model [9]. IDM is a longitudinal traffic model, so we had to expand it to handle multiple lanes and crossroads - the original IDM works for an unlimited one-way, one-lane road - we did not use Treiber's MOBIL lane changing model as it is better adapted to motorways than to urban lane changing decisions.

The data provided by geographic providers does not include right of passage or traffic lights at crossroads. We therefore had to develop our own model aiming at the simulation of crossroads in a heavy traffic.

When a vehicle reaches a crossroad, it slows down and acts according to the fluidity of traffic in the crossroad, in the edge it is currently upon and in the edge it whishes to go to. If they are encumbered, it will more often wait in its way, but it may enter the crossroad and wait here, thus encumbering it (with a more or less strong individual tendency to do so). If the edge it is aiming at has multiple lanes, it will watch both of them, to see if it could fit in one.

## C. Tactical Behavior

Although vehicles have an original plan, they will adapt it to what they perceive of their environment. When stuck in what they perceive is a jam, they will try to find alternate routes out of it to their destination.

The first method we used is the simpler one. When a vehicle doesn't move enough to its liking - this saturation is variable amongst agents - it tries to take alternate paths as soon as possible, favoring the roads with least dense circulation - although this is not absolute, so as to avoid loops. 

Once it estimates it's far enough from the jam that sprang this alternate behavior, it resumes using the best path table to find a suitable one to its destination.

The second one is more sophisticated, as it will have uses beyond mere traffic avoidance. Its intelligence is modeled more in the Transporter agents than in the vehicles. 

Transporters estimate their encumbrance. To do that, they employ direct measure - how many vehicles do they contain over how many vehicles can they contain in average - but also statistics on the proportion of vehicles they contain that are annoyed by the traffic - as described in the first method - and information from the Transporters around them. If based on this they decide they are *encumbered* they also warn the Transporters around them of their perception. This will lower the threshold for them to feel encumbered.

Once *encumbered*, the nodes they are connected to will recompute their best path table, using a huge weight for the encumbered edges. When a vehicle arrives to one of these nodes and wants to go to one of the jammed edges, it is informed of the edge state, and it can recompute a route around it, or take the edge anyway.

This mechanism is also theoretically interesting, as it is an implementation of an emergent property: the interactions of individual behavior affect the behavior of an agent of an higher scale, who alters his behavior, which in turns transforms the behavior of the lower level vehicles. This reifies the perception an individual driver can have of the state and dynamics of the traffic he is plunged in as a whole.

A Transporter can also be *barred*, because of an accident for example. In that case the same mechanism is used, except that this time circumnavigating is mandatory.

The mechanism of these two states is especially useful in what was the original purpose of our model and its main application: simulating urban important accidents - such as industrial accident - as the modeler can bar the edges it wants as part of his scenario, and see how the traffic adapts to it in simulation real time, as the vehicles discover the evolving road network and fluxes. This is the application that will be developed in the part 2 of our article.

![0_image_0.png](0_image_0.png)

![0_image_1.png](0_image_1.png)

## Iv. Conclusion

This article is more technical than thematic. We tried to write the kind of article we would have liked to read when we started on this work. We have nonetheless done thematic validation.

One of the problems for the validation is that modeling as seldom been taken to such a detail level. This level is necessary because of the multi-level nature of traffic: the decision of one driver can start a jam or jams for thousands of drivers, half a town away, half an hour later, a la butterfly effect. Macro model of fluxes, which dominate the field of 