# Paired Comparisons-Based Interactive Differential Evolution

Hideyuki Takagi Kyushu University Faculty of Design Fukuoka, Japan http://www.design.kyushu-u.ac.jp/~takagi Abstract**—We propose Interactive Differential Evolution (IDE)** 
based on paired comparisons for reducing user fatigue and evaluate its convergence speed in comparison with Interactive Genetic Algorithms (IGA) and tournament IGA. User interface and convergence performance are two big keys for reducing Interactive Evolutionary Computation (IEC) user fatigue. 

Unlike IGA and conventional IDE, users of the proposed IDE and tournament IGA do not need to compare whole individuals each other but compare pairs of individuals, which largely decreases user fatigue. In this paper, we design a pseudo-IEC user and evaluate another factor, IEC convergence performance, using IEC simulators and show that our proposed IDE converges significantly faster than IGA and tournament IGA, i.e. our proposed one is superior to others from both user interface and convergence performance points of view. 

Evolutionary Algorithms; Differential Evolution; Interactive Evolutionary Computation, Paired Comparison, Gaussian Mixture Model 

## I. Introduction

There are many optimization tasks that it is not easy or almost impossible to design scales for evaluating target systems quantitatively but that we can evaluate subjectively. 

Some of these tasks include, for example, drawing montage based on witness's memory, fitting a hearing-aid to get satisfactory sounds, designing cute or lovely motions of home robots. Interactive Evolutionary Computation (IEC) 
has been applied to these tasks in a wide variety of application areas [1]. 

The biggest drawback of the IEC is IEC user fatigue due to human cooperation with tireless computer. IEC user has to evaluate generated individuals, which makes the user boring and tired. The population size and evolving generations are limited due to the fatigue, and 10 - 20 individuals and 10 - 20 generations are frequently used in IEC, but they are quite fewer than those of normal EC search and result slower convergence. The slower convergence is other factor of the IEC user fatigue. 

Several trials have been done to solve the fatigue problem [1]. Improving IEC user interface is one of them. 

Some of them are: improving display interface to help user to Denis Pallez Nice Sophia-Antipolis University I3S Laboratory - CNRS UMR 6070 Nice, France http://www.i3s.unice.fr/~dpallez/
compare individuals easily, improving input interface by reducing evaluation levels, for example 5 evaluation levels rather than 100 ones, and data visualization by projecting the distribution of individuals in the n-D searching space onto 2- D or 3-D space, and others . 

Predicting IEC user's evaluation using trained prediction models is other trial. The model is used as a fitness function of normal EC search and is combined with IEC to accelerate IEC search. To train these models using IEC user's evaluations in past generations, a distance-based model [1], 
genetic programming [2], neural networks [1], and Support Vector Machine [3, 4] has been used. References [5, 6] 
propose to use an eye-tracker to avoid the input of fitness values and even to avoid the user for selecting best individuals: it could be done by correctly interpreting cognitive store data; for instance, by considering time spent on evaluating an individual. 

Another possible solution is to use tournament IEC [7] 
that is based on only paired comparisons rather than comparing all individuals. This technique is easier for an IEC 
user to evaluate a pair of individuals than to compare all individuals and evaluate them at once. However, drawback is its less information for giving fitness values to all individuals due to lack of comparison of all individuals, which means that the fitness includes more noise and may result slow convergence. Simulated breeding is an IEC method that IEC 
user just chooses better individuals among all, and one click selection of a pointing device is an easy IEC user interface. Although it compares all individuals unlike tournament IEC, 
the 1 bit evaluation includes more quantization noise in fitness than any other evaluations and may makes IEC convergence slower [8]. 

Introducing new type of EC and accelerating IEC 
convergence are other approaches. Differential Evolution 
(DE) [9] is an optimization technique come to be frequently used in this decade. DE has two possible advantages that completely fall into IEC conditions: first one is the use of comparisons between only two individuals (paired comparisons) and second one is its potential of faster convergence. The objective of this paper is to evaluate Interactive DE (IDE) [10-12] in comparison with conventional IEC approaches and show its potential.