fewer generations and improve IDE in practical conditions. 

## D. Results

Unlike DE and GA, two tournament GA's use rank order fitness, i.e. relative fitness. All IDE, IGA, and tournament IGA use relative fitness. If we make a graph of these relative fitness along with generations, of course we cannot observe convergence. Normalization of fitness also cannot solve it. 

However, for making comparisons, we must observe their convergence in a searching space with their absolute function values of the individuals evolved based on the relative fitness. 

## V. Discussion

We statistically tested whether DE or IDE is significantly 

![0_image_0.png](0_image_0.png)

better than others or worse than the best at each generation. 

Results are shown in Figure 2. 

Figure 2. Sign test for DE (IDE); blue dots mean that DE (or IDE) is significantly better than others in the (1) case, and the red dots mean that DE (IDE) is significantly poorer than at least one of others. 

## Our Observation Is That

- DE is always the best or at least not poorer than others significantly in early generations. It becomes the best after 10-20 generations for three different complexities of tasks with small (16) and large (128) population size. 

- IDE with 16 population size shows similar tendency.

However, the generations that the IDE becomes significantly better than other after about the 10th generation for simple task (3-D Gaussian mixture model) and 40th generation for complex tasks (5-D, 
7-D, and 10-D models). 

- IDE with 128 population size does not have reality as IEC, and its results themselves are not important. 

## Vi. Conclusion

Better IEC user interface and fast convergence are necessary to reduce IEC user fatigue. We proposed paired comparison-based IDE that can reduce IEC user fatigue greatly than comparison of all individuals. Especially, it is effective when IEC tasks handle individuals displayed timesequentially, i.e. sounds or movies. Since this advantage is obvious, we evaluated another key point, convergence speed and show the superiority of IDE to IGA and two tournament IGA's. From these two advantages of the IDE, we can say that our proposed IDE is the better than conventional IDE, IGA, and tournament IGA's. 

Our next step of this research is to evaluate these advantages of our IDE found though IEC simulations is really effective for human IEC. We are planning to evaluate the proposed IDE using real human users. 

## Vii. References

[1] H. Takagi, "Interactive Evolutionary Computation: Fusion of the Capacities of EC Optimization and Human Evaluation," in IEEE, 
2001, pp. 1275-1296. 

[2] D. Costelloe and C. Ryan, "Genetic Programming for Subjective Fitness Function Identification," in Genetic Programming, LNCS, Ed., 
2004, pp. 259-268. 

[3] X. Llorà and K. Sastry, "Combating User Fatigue in iGAs : Partial Ordering , Support Vector Machines and Synthetic Fitness," in GECCO, Washington, D.C., USA, 2005, pp. 1363 - 1370. 

[4] X. Llorà, K. Sastry, and F. Alias, "Analyzing Active Interactive Genetic Algorithms using Visual Analytics," in Genetic and Evolutionary Computation (GECCO), Seattle, Washington, USA, 2006, pp. 1417-1418. 

[5] T. Holmes and J. Zanker, "Eye on the Prize: Using Overt Visual Attention to Drive Fitness for Interactive Evolutionary Computation," in GECCO (Genetic and Evolutionary Computation COnference), 
Atlanta, Georgia, USA, 2008, pp. 1531-1538. 

[6] D. Pallez, P. Collard, T. Baccino, and L. Dumercy, "Eye-Tracking Evolutionary Algorithm to minimize user fatigue in IEC applied to Interactive One-Max problem," in GECCO (Genetic and Evolutionary Computation COnference), University College, London, 2007, pp. 2883-2886. 

[7] B. Johanson, "Automated Fitness Raters for the GP-Music System," 
University of Birmingham, Masters Degree Final Project 1997. 

[8] Y. Nakano and H. Takagi, "Influence of Quantization Noise in Fitness on the Performance of Interactive PSO," in Congress on Evolutionary Computation, Trondheim, Norway, 2009. 

[9] R. Storn and K. Price, "Differential Evolution - A Simple and Efficient Heuristic for global Optimization over Continuous Spaces," Journal of Global Optimization, vol. 11, pp. 341–359, 1997. 

[10] T. Akbal, G. N. Demir, A. E. Kanlikiliçer, M. C. Kus, and F. H. Ulu, 
"Interactive Nature-Inspired Heuristics for Automatic Facial Composite Generation," in Genetic and Evolutionary Computation Conference (GECCO), Undergraduate Student Workshop, Seattle, WA, USA, 2006. 

[11] A. E. Kanlıkılıçer, "Interactive Differential Evolution for Facial Composite Generation," in Genetic and Evolutionary Computation 
(GECCO), Seatle, USA, 2006. 

[12] B. Kurt, A. S. Etaner-Uyar, T. Akbal, N. Demir, A. E. Kanlikilicer, M. 

C. Kus, and F. H. Ulu, "Active Appearance Model-Based Facial Composite Generation with Interactive Nature-Inspired Heuristics " in Multimedia Content Representation, Classification and Security, Lecture Notes in Computer Science. vol. 4105, 2006, pp. 183-190. 

[13] P. J. Angeline and J. B. Pollack, "Competitive Environments Evolve Better Solutions for Complex Tasks," in 5th International Conference on Genetic Algorithms, Urbana/Champaign IL, USA, 1993, pp. 264 - 
270. 

[14] L. Panait and S. Luke, "A Comparison Of Two Competitive Fitness Functions," in GECCO (Genetic and Evolutionary Computation COnference), 2002, pp. 503 - 511. 

[15] A. P. Engelbrecht, Computational Intelligence: An Introduction, Second Edition ed.: John Wiley and Sons, 2007. 