the customer with a set of alternative solutions for each requested transaction. These solutions are constructed through the use of a specially developed algorithm for retrieving optimal and sub-optimal solutions. Moreover, through a dedicated recommender agent [9, 22], which builds on Web Services concepts [26], the system assists the customer further towards making the appropriate decisions. 

The remainder of this paper is structured as follows: 
Section 2 reports on background issues from the area of recommender systems, paying particular attention to recommendation approaches. Section 3 describes the basic aspects of our approach, which concern the selection of transportation plans and the evaluation of alternative solutions. Section 4 focuses on issues raised during the integration of the recommendation module, the formulation of the recommendation policy, and the exploitation of software agents and Web Services technologies. Finally, Section 5 concludes the paper and highlights future work directions. 

## 2. Related Work

The most widely adopted recommendation techniques are Collaborative Filtering (CF) and Knowledge Based Recommendation (KBR), each one possessing its own strengths and weaknesses. Collaborative Filtering (CF) 
[17, 18] is the most commonly used recommendation technique to date. The basic idea of CF-based algorithms is to provide item recommendations or predictions, based on the opinion of other like-minded users. In a typical CF 
scenario, there is a list of m users *U = {u1, u2, …, um}* and a list of n items *I = {i1, i2, …, in}.* Each user ui is associated with a list of items Iui, for which the user has expressed his/her opinion. Opinions can be explicitly given by the user as a rating score (within a certain numerical scale), or implicitly derived from transaction records (by analyzing timing logs, mining web hyperlinks and so on). For a particular user ua, the task of a collaborative filtering algorithm is to find an *item likeness* that can be of two forms: 

- *Prediction:* this is a numerical value, Pi, expressing the predicted likeness of item i (i does not belong to Iua) for the user. The predicted value is within the same scale (e.g. from 1 to 5) as the opinion values provided by ua [19]. 

 
to the above customer's request is to involve both X and Y and fragment the intended overall itinerary to the related sub-routes. It is also noted that these carriers may be associated with diverse transportation means, such as trains, trucks, ships and airplanes. 
- *Recommendation:* this is a list of N items Ir (Ir is a subset of I) that the user will like most (the recommended list must contain items not already selected by the user). This outcome of CF algorithms is also known as *Top-N* recommendation [20]. 

On the other hand, KBR attempts to suggest objects based on inferences about a user's needs and preferences. In some sense, all recommendation techniques could be described as doing some kind of inference. Knowledgebased approaches are distinguished in that they utilize functional knowledge; in other words, they have knowledge about how a particular item meets a particular user need and can therefore reason about the relationship between a need and a possible recommendation. The user profile can be any knowledge structure that supports this inference. In the simplest case, as in *Google*, it may simply be the query that the user has formulated. The *Entrée* system and several other recent systems [23], employ techniques from case-based reasoning for knowledgebased recommendations. 

The knowledge used by a knowledge-based recommender system can take many forms. *Google* uses information about the links between web pages to infer popularity and authoritative value [1]. *Entrée* uses knowledge of cuisines to infer similarity between restaurants. Utility-based approaches calculate a utility value for objects to be recommended; in principle, such calculations could be based on functional knowledge. 

However, existing systems do not use such inference mechanisms, thus requiring users to do their own mapping between their needs and the features of products, either in the form of preference functions for each feature, as in the case of *Tête-à-Tête*, or answers to a detailed questionnaire, as in the case of *PersonaLogic* [2]. Knowledge-based recommender systems are prone to the drawback of all knowledge-based systems: the need for knowledge acquisition. More specifically, there are three types of knowledge that are involved in such systems: 
- *Catalog knowledge:* Knowledge about the objects being recommended and their features. For example, the system should know that "Gasoline" is a type of "Fuel". 

- *Functional knowledge:* The system must be able to match the user's needs with the object that might satisfy those needs. For example, a recommendation module should know that the transportation of toxics require a higher safety level. 

- *User knowledge:* To provide good recommendations, the system must have some knowledge about the user. 