During the construction of the available transportation solutions, our approach excludes solutions that do not comply with the customer's requirements. More specifically, a set of predefined rules is employed to exclude the alternative solutions that do not correspond to the specific freight transportation's requirements and customer preferences. Table 1 summarizes the constraints to be met for each transportation plan (for the *"User* Defined" plan, this process takes into account the constraints set by the user). In all cases, solutions that do not satisfy these constraints are discarded. 

## 3.2 A Methodology For The Selection Of Alternative Route Paths

In our former work [10, 27], we have presented an algorithm for constructing optimal (direct or modular) solutions for a requested transportation transaction. This algorithm was taking into account the cost and duration of each sub-route, as well as the cost and duration upper bounds (as they had been set by the user). If no optimal solution could be constructed, the algorithm terminated without providing any solutions. To better handle such cases, our approach uses an elaborated version of Dijkstra's shortest path algorithm [4] to construct suboptimal solutions. Even if such solutions cannot be characterized as optimal, they represent acceptable alternatives for a specific transportation request. 

As it can be retrieved from the related literature [4], 
shortest path algorithms use a bidirectional, singleweighted graph to represent a connected set of vertices 
(Vi) through a number of arcs Aij (from Vi to Vj). Our algorithm takes into consideration each Aij and its correspondent weight (Wij) in order to produce a route path from a starting point (S) to an ending point (E) that minimizes the total weight (WSE). The complexity of our approach consists in the presence of a pair of variables that affect each arc's weight, namely the cost and the duration. Due to the fact that there exist two weights for each arc (cost and duration), we confronted the problem of unifying these weights into a single one, in order to proceed with the ranking of the solutions. As shown in Figure 2, each arc's Aij weight (Wij) consists of a cost weight (*Wcost-ij*) and a duration weight (*Wduration-ij*). It is obvious that: 

W =W +W ij cost - ij duration - ij (1) 

![0_image_0.png](0_image_0.png)

Having defined the total weight for each arc (Aij), we encountered the problem of adding these two parameters that are measured in different units (Euros and hours, respectively). This problem was confronted by applying a normalization technique that divided both the *costij* and durationij of an arc with its correspondent maximum cost and duration of the sub-route. It is: 

$$\begin{array}{r l}{{\mathrm{W}}_{\mathrm{duration}\cdot\mathrm{ij}}}&{{}={\frac{\mathrm{duration}_{\mathrm{ij}}}{\mathrm{max}(\mathrm{duration}_{\mathrm{ij}})}}}\\ {{\mathrm{W}}_{\mathrm{cost}\cdot\mathrm{ij}}}&{{}={\frac{\mathrm{cost}_{\mathrm{ij}}}{\mathrm{max}(\mathrm{cost}_{\mathrm{ij}})}}}\end{array}\quad{\mathrm{(3)}}$$

Another issue that came up after the weight normalization procedure concerned the solutions' ranking. To address this problem, our approach provides the user with different solutions by using a pair of weight coefficients 
(costCoef and durationCoef) and by calculating solutions corresponding to alternative combinations of the weights of the cost and duration criteria (see Figure 3), according to the formula: 

$\rm W_{ij}=(costCoef*W_{cat-ij})+(durationCoef*W_{duration-ij})$ (4)
The cost and duration coefficients take values from the set 
{0, 0.1, 0,2, …, 1}. The main idea of this process is to provide the algorithm with alternative weights (wij), each one expressing a different combination of cost and duration parameters. At the beginning of this procedure, we calculate the weight of each sub-route by taking into consideration only the duration parameter (we set the cost coefficient to 0 and the duration coefficient to 1). Then, in a step-wise way, we decrease the duration coefficient by 