The last phase of recommendation refers to the selection or synthesis of the appropriate recommendation technique. This objective will be reached through the definition of well structured rules that will be applied for each transaction. The *Recommender Agent* of our system takes the initiative to select the most appropriate recommendation technique. For example, for a particular itinerary from point i to point j, taking into consideration that the customer has selected a certain plan, a rule for the specific itinerary could lead to the recommendation of a carrier that is different than the one suggested by the CF technique, based on the carriers' evaluation process described earlier in this section. The recommendation methodology described above is graphically presented in Figure 5, through a data flow diagram. 

![0_image_0.png](0_image_0.png)

Due to the large amount of data the recommendation module takes into account in order to provide knowledgebased recommendations, the database model has been thoroughly considered. The system's database has been designed through the use of SQL Server 2005 Management Console, in order to accomplish further with the customers' needs. Much attention has been paid into the reorganization of data tables' fields, as well as into the representation of the entities' relationships [16]. The database model that participates in the knowledge construction of the recommendation's phase is presented in Table 2. 

Table 2: Recommendation Module's Database Model 

| Table Name                  | Description                           |
|-----------------------------|---------------------------------------|
| Transactions                | Transactions in progress              |
| Transaction's Subroutes     | Transactions sub-routes in progress   |
| Transactions _Rating        | Completed Transactions' evaluation    |
| Carriers_Rating             | Carrier evaluation with completed     |
| Users_Reliability           | Customers reliability evaluation      |
| Temp_Transactions           | Proposed transaction itineraries      |
| Temp_Transactions_Subroutes | Subroutes of the proposed itineraries |

## 4.2 Calculation Of Recommendation Score

After the ranking phase, the evaluation of each alternative route retrieved is performed. Our system retrieves all possible transportation routes that can be constructed for a given transaction request. These routes are presented to the user through an appropriate designed user interface. 

The corresponding user interface enables the user to either select one of the proposed routes (in this case, he/she will be asked to complete the transaction), or to be redirected to a user-friendly interface where he/she can receive recommendations for each separate route. The evaluation of a transaction is based on various criteria, such as: 

- Cost - Duration - Safety - Reliability - Average scores of the above carriers' elements. - Average scores of the sub-routes contained in the transaction 
- The number of times that the specific route has been selected by other customers (popularity). 

- Number of transloadings 
The recommendation procedure is implemented through the evaluation of both the transactions and the transportation companies involved. It is a complex 