
## 4.3 An Example

This subsection presents an example of the recommendation process and its runtime environment. 

Having performed the optimal routes retrieval algorithm
[4, 15], the user is transferred to the recommendation interface, where the results of the recommendation process are presented (Figure 6). At this phase, the evaluation of the itineraries is executed. More specifically, for every solution that has been retrieved for a requested transaction, the user may further consider its sub-routes. For each subroute, the system calculates the average score that the carrier has received for its reliability during the transaction, as well as the average score for the transaction's duration. During the calculation of the above averages, the scores that each carrier (or each route) has received are multiplied by a user's reliability coefficient. This is performed in order to add a level of significance into a reliable user's opinion (compared with a less reliable one). Reliability refers to the number of times that a user has rated an itinerary, and not by the fact that his/her evaluation was considered as being strict or not. In addition to the above evaluation, a similar procedure takes place with respect to the safety and the overall carrier's reliability during the transaction. Both the average score of the specific elements (duration, reliability, safety, general reliability) and the overall score are stored in the system's database. When this procedure is completed for all itineraries' sub-routes, an average of all scores is extracted. The final score of the itinerary is the sum of the carriers' and the sub-routes' overall score, normalized by the overall cost and the number of intermediate transloadings. Moreover, the system retrieves information related to the completion of the above itineraries and their correspondent frequency. This procedure aims at checking whether a specific itinerary is constantly selected by other users. The popularity of each route is presented to the user later, in order not to affect his/her decision. 

Initially, the recommended solutions are shown to the user according to their final score (top table of the interface shown in Figure 6). The user may then see each solution's details; by clicking on the "View Details" link (which appears at each entry of the top table), the interface expands dynamically and a second table appears (entitled 
"Sub-Route Details"), containing information about the sub-routes of the selected itinerary and the overall scores of each sub-route. Clicking on the "More Details" link, the user is provided with additional information about each sub-route (such as scores for its duration, safety and reliability). Moreover (by exploiting the "Show" link at 

![0_image_0.png](0_image_0.png) the "Top-10 Carriers" column), the user is given the opportunity to compare a sub-route's carrier with any of the Top-10 carriers that exist for the particular sub-route 
(this is a common practice in CF techniques). In such a case, the interface of Figure 6 expands further and a third table, entitled "Top-10 Carriers", appears. When selecting a carrier from this table, by clicking on the 
"Select" link, the corresponding differences (in terms of cost, duration and carrier's rating) are presented in the bottom right part of the window (under the header "Additional Features"). 

## 4.4 Implementation Issues

A new software agent, namely the Recommender Agent (RA), has been implemented and interconnected with a correspondent Web Service, in order to coordinate the overall recommendation process. The main tasks of the RA concern the coordination of the recommendation module, depending on the characteristics of each transaction. Through these formally modeled tasks, RA provides continuous assistance to customers, while it remains active and capable to adapt its "behavior" into a rapidly changing environment. RA is responsible for the coordination of the whole process, as it interacts with the other software agents of the system [10]. Moreover, the recommendation policy of our system builds on Web Services concepts [26]. A Web Service is a URLaddressable software resource that performs functions and provides answers. It is constructed by taking a set of software functionality and wrapping it up so that the 