# Decomposition Of The Nvalue Constraint

Christian Bessiere1, George Katsirelos2, Nina Narodytska2, Claude-Guy Quimper3, and Toby Walsh2 1 LIRMM, CNRS, Montpellier, email: bessiere@lirmm.fr 2 NICTA and University of NSW, Sydney, Australia, email:
{george.katsirelos,nina.narodytska,toby.walsh}@nicta.com.au 3 Ecole Polytechnique de Montr´eal, email: cquimper@gmail. ´ com Abstract. We study decompositions of NVALUE, a global constraint that can be used to model a wide range of problems where values need to be counted.

Whilst decomposition typically hinders propagation, we identify one decomposition that maintains a global view as enforcing bound consistency on the decomposition achieves bound consistency on the original global NVALUE constraint.

Such decompositions offer the prospect for advanced solving techniques like nogood learning and impact based branching heuristics. They may also help SAT
and IP solvers take advantage of the propagation of global constraints.

## 1 Introduction

Global constraints are an important feature of constraint programming. They capture common patterns in real world problems, and provide efficient propagators for pruning the search space. Consider, for example, the NVALUE constraint which counts the number of values used by a set of variables [1]. This global constraint can model problems where values represent resources. This is a common constraint that can be used to model many practical problems such as timetabling and frequency allocation. Whilst enforcing domain consistency on the NVALUE constraint is NP-hard [2], bound consistency is polynomial to achieve. At least four different propagation algorithms for the NVALUE constraint have been proposed, some of which achieve bound consistency [3–5].

We have recently proposed simulating propagators for global constraints with decompositions. For instance, we have shown that carefully designed decompositions of the global ALL-DIFFERENT and GCC constraints can efficiently simulated the corresponding bound consistency propagators [6]. We turn now to the NVALUE constraint.

We study a number of different decompositions, one of which permits the achievement of bound consistency on the NVALUE constraint. Such decompositions open out a number of promising directions. For example, they suggest schema for learning nogoods. As a second example, such decompositions may help construct nogood and impact based branching heuristics. As a third and final example, such decompositions may permit SAT and IP solvers to take advantage of the inferences performed by the propagators of global constraints. We have, for instance, seen this with our decompositions of the ALL-DIFFERENT constraint [6].

arXiv:0909.3273v1 [cs.AI] 17 Sep 2009