
## 3.1 Simple Decomposition

We can decompose the NVALUE constraint by introducing 0/1 variables and posting the following constraints:

$$\begin{array}{r l}{X_{i}=j\to B_{j}=1\quad}&{{}\forall1\leq i\leq n,1\leq j\leq d}\\ {B_{j}=1\to\bigvee_{i=1}^{n}X_{i}=j\quad}&{{}\forall1\leq j\leq d}\\ {\quad\quad\sum_{j=1}^{m}B_{j}=N}\end{array}$$

Unfortunately, this simple decomposition hinders propagation. It can be BC whereas BC on the corresponding NVALUE constraint detects disentailment. Theorem 1 *BC on* NVALUE *is stronger than BC on its decomposition into (1) to (3).* Proof: Clearly BC on NVALUE is at least as strong as BC on the decomposition. To show strictness, consider X1 ∈ {1, 2}, X2 ∈ {3, 4}, Bj ∈ {0, 1} for 1 ≤ j ≤ 4, and N = 1. Constraints (1) to (3) are BC. However, the corresponding NVALUE constraint has no bound support and thus enforcing BC on it detects disentailment. ✷
We observe that enforcing DC instead of BC on constraints (1) to (3) in the example of the proof above still does not prune any value. To decompose NVALUE without hindering propagation, we must look to more complex decompositions.

## 3.2 Decomposition Into Atmostnvalue And Atleastnvalue

Our first step in decomposing the NVALUE constraint is to split it into two parts: an ATMOSTNVALUE and an ATLEASTNVALUE constraint.

ATLEASTNVALUE([X1, . . . , Xn], N) holds iff N **≤ |{**Xi|1 ≤ i ≤ n}| whilst ATMOSTNVALUE([X1, . . . , Xn], N) holds iff |{Xi|1 ≤ i ≤ n**}| ≤** N.

Running Example. *Consider a* NVALUE constraint over the following variables and values:

![0_image_0.png](0_image_0.png)

Suppose we decompose this into an ATMOSTNVALUE *and an* ATLEASTNVALUE *constraint. Consider the* ATLEASTNVALUE *constraint. The 5 variables can take at most* 4 different values because X2, X3, X4, and X5 can only take values 2, 3 and 4. Hence, there is no bound support for N = 5*. Enforcing BC on the* ATLEASTNVALUE *constraint therefore prunes* N = 5*. Consider now the* ATMOSTNVALUE *constraint. Since* X2 and X4 *guarantee that we take at least 2 different values, there is no bound support* for N = 1*. Hence enforcing BC on an* ATMOSTNVALUE *constraint prunes* N = 1*. If* X1 = 1, 3 or 5*, or* X5 = 3 then any complete assignment uses at least 3 different values. Hence there is also no bound support for these assignments. Pruning these values