# Symmetries Of Symmetry Breaking Constraints George Katsirelos

NICTA, Sydney, Australia george.katsirelos@nicta.com.au

## Abstract

Symmetry is an important feature of many constraint programs. We show that any symmetry acting on a set of symmetry breaking constraints can be used to break symmetry. Different symmetries pick out different solutions in each symmetry class.

We use these observations in two methods for eliminating symmetry from a problem. These methods are designed to have many of the advantages of symmetry breaking methods that post static symmetry breaking constraint without some of the disadvantages. In particular, the two methods prune the search space using fast and efficient propagation of posted constraints, whilst reducing the conflict between symmetry breaking and branching heuristics. Experimental results show that the two methods perform well on some standard benchmarks.

## 1 Introduction

Symmetry occurs in many problems. For instance, certain workers in a staff rostering problem might have the same skills and availability. If we have a valid schedule, we may be able to permute these workers and still have a valid schedule. We typically need to factor such symmetry out of the search space to be able to find solutions efficiently. One popular way to deal with symmetry is to add constraints which eliminate symmetric solutions (see, for instance, [1; 2; 3; 4; 5; 6; 7]). A general method is to add constraints which limit search to the lexicographically least solution in each symmetry class. Such symmetry breaking is usually simple to implement and is often highly efficient and effective [8; 9]. Even for problems with many symmetries, a small number of symmetry breaking constraints can often eliminate much or all of the symmetry.

One problem with posting symmetry breaking constraints is that they pick out particular solutions in each symmetry class, and branching heuristics may conflict with this choice. In this paper, we consider two methods for posting symmetry breaking constraints that tackle this conflict. The two methods exploit the observations that any symmetry acting on a set of symmetry breaking constraints can be used to break symmetry, and that different symmetries pick out different

# Toby Walsh

NICTA and UNSW, Sydney, Australia toby.walsh@nicta.com.au solutions. The first method is *model restarts* which was proposed in [10]. We periodically restart search with a new model which contains a different symmetry of the symmetry breaking constraints. The second method posts a symmetry of the symmetry breaking constraint dynamically during search. The symmetry is incrementally chosen to be consistent with the branching heuristic. Our experimental results show that both methods are effective at reducing the conflict between branching heuristics and symmetry breaking.

## 2 Background

A constraint satisfaction problem (CSP) consists of a set of variables, each with a domain of values, and a set of constraints specifying allowed combinations of values for subsets of variables. A solution is an assignment to the variables satisfying the constraints. We write sol(C) for the set of all solutions to the constraints C. A common method to find a solution of a CSP is backtracking search. Constraint solvers typically prune the backtracking search space by enforcing a local consistency property like domain consistency. A constraint is *domain consistent* iff for each variable, every value in its domain can be extended to an assignment satisfying the constraint. We make a constraint domain consistent by pruning values for variables which cannot be in any satisfying assignment. During the search for a solution, a constraint can become entailed. A constraint is *entailed* when any assignment of values from the respective domains satisfies the constraint, For instance, X1 < Xn is entailed iff the largest value in the domain of X1 is smaller than the smallest value in the domain of Xn. A constraint is *dis-entailed* when its negation is entailed. For instance, **X < Y** is dis-entailed if and only if the smallest value in the domain of X is larger than or equal to the largest value in the domain of Y .

CSPs can contain symmetry. We consider two common types of symmetry (see [11] for more discussion). A variable symmetry is a permutation of the variables that preserves solutions. Formally, a variable symmetry is a bijection σ on the indices of variables such that if X1 = d1**, . . . , X**n = dn is a solution then Xσ(1) = d1**, . . . , X**σ(n) = dn is also. A *value* symmetry, on the other hand, is a permutation of the values that preserves solutions. Formally, a value symmetry is a bijection θ on the values such that if X1 = d1**, . . . , X**n = dn is a solution then X1 = θ(d1)**, . . . , X**n = θ(dn) is also. Symmetries can more generally act on both variables and values.