Our methods also work with such symmetries. As the inverse of a symmetry and the identity mapping are symmetries, the set of symmetries of a problem forms a group under composition. We will use a simple running example which has a small number of variable and value symmetries. This example demonstrates that we can use symmetry itself to pick out different solutions in each symmetry class.

Running Example. *The all interval series problem (prob007* in CSPLib.org *[12]) asks for a permutation of 0 to* n − 1 so that neighbouring differences form a permutation of 1 to n−1. We model this as a CSP with Xi = j iff the i*th number* is j*, and auxiliary variables for the neighbouring differences.*
One solution for n = 11 is:
X1, X2**, . . . , X**11 = 3, 7, 4, 6, 5, 0, 10, 1, 9, 2, 8 (a)
This model has a number of different symmetries. First, there is a variable symmetry σrev *that reverses any solution:*
X1, X2**, . . . , X**11 = 8, 2, 9, 1, 10, 0, 5, 6, 4, 7, 3 (b)
Second, there is a value symmetry θinv that inverts values. If we subtract all values in (a) from 10, we generate a second
(but symmetric) solution:
X1, X2**, . . . , X**11 = 7, 3, 6, 4, 5, 10, 0, 9, 1, 8, 2 (c)
Third, we can do both. By reversing and inverting (a), we generate a fourth (but symmetric) solution:
X1, X2**, . . . , X**11 = 2, 8, 1, 9, 0, 10, 5, 4, 6, 3, 7 (d)
The model thus has four symmetries in total: σid (the identity mapping), σrev, θinv*, and* θinv ◦ σrev. ♣

## 3 Symmetry Breaking

One common way to deal with symmetry is to add constraints to eliminate symmetric solutions [1]. Two important properties of symmetry breaking constraints are soundness and completeness. A set of symmetry breaking constraint is sound iff it leaves at least one solution in each symmetry class, and complete iff it leaves exactly one solution. Running Example. Consider again the all interval series problem. To eliminate the reversal symmetry σrev*, we can* post the constraint:
X1 < X11 (1)
This eliminates solution (b) as it is the reversal of (a). To eliminate the value symmetry θinv*, we can post:*
X1 ≤ 5, X1 = 5 ⇒ X2 < 5 (2)
This eliminates solution (c) as it is the inversion of (a). Finally, to eliminate the third symmetry θinv ◦ σrev where we both reverse and invert the solution, we can post:
hX1, . . . , X6i ≤lex h10 − X11**, . . . ,** 10 − X6i (3)
This eliminates solution (a) as it is the reversal and inversion of (d). Note that of the four symmetric solutions given earlier, only (d) with X1 = 2 and X11 = 7 satisfies all these symmetry breaking constraints. The other three solutions are eliminated. Thus (1) to (3) are a sound and complete set of symmetry breaking constraints. ♣

We now show that *any symmetry* acting on a set of symmetry breaking constraints itself breaks the symmetry in a
problem. Different symmetries pick out different solutions
in each symmetry class. To prove this, we need to consider
the action of a symmetry on a symmetry breaking constraint. Symmetry has been defined acting on assignments. We lift
this definition to constraints. The action of a variable symmetry on a constraint changes the variables on which the constraint acts. More precisely, a variable symmetry σ applied
to the constraint C(Xj **, . . . , X**k) gives C(Xσ(j)**, . . . , X**σ(k)).
The action of a value symmetry is also easy to compute. A
value symmetry θ applied to the constraint C(Xj **, . . . , X**k)
gives C(θ(Xj )**, . . . , θ**(Xk)).
Running Example. To illustrate how we can break symmetry
with the symmetry of a set of symmetry breaking constraints,
we consider symmetries of (1), (2) and (3).
If we apply σrev to (1), we get an ordering constraint that
again breaks the reversal symmetry:
$$X_{\sigma_{r e v}(1)}<X_{\sigma_{r e v}(11)}$$
This simplifies to:
If we apply σrev to (2), we get constraints that again breaks
the inversion symmetry:
X11 ≤ 5, X11 = 5 ⇒ X10 < 5
Finally, if we apply σrev *to (3), we get a constraint that again*
breaks the combined reversal and inversion symmetry:
hX11, . . . , X6i ≤lex h10 − X1**, . . . ,** 10 − X6i
Note that of the four symmetric solutions given earlier, only
(c) satisfies σrev of (1), (2) and (3).
We can also break symmetry with any other symmetry of
the symmetry breaking constraints. For instance, if we apply
θinv ◦ σrev to (1), we get a constraint that again breaks the
reversal symmetry: This simplifies to:
If we apply θinv ◦ σrev *to (2), we get constraints that again*
breaks the inversion symmetry:
10 − X11 ≤ 5, 10 − X11 = 5 ⇒ 10 − X10 < 5
$$X_{11}<X_{1}$$
This simplifies to:
X11 ≥ 5, X11 = 5 ⇒ X10 > 5
Finally, if we apply θinv ◦ σrev to (3), we get a constraint that
again breaks the combined reversal and inversion symmetry:
h10 − X11, . . . , 10 − X6i ≤lex hX1**, . . . , X**6i
Note that of the four symmetric solutions given earlier, only
(a) satisfies θinv ◦ σrev *of (1), (2) and (3).* ♣
The running example illustrates that we can break symmetry with a symmetry of a set of symmetry breaking constraints. We now prove that this holds in general:
$$X_{1}<X_{11}$$
$$10-X_{11}<10-X_{11}$$