Any symmetry acting on a set of symmetry breaking constraints itself breaks symmetry.

More precisely, if a set of symmetry breaking constraints is sound, then any symmetry of these constraints is also sound.

Similarly, if a set of symmetry breaking constraints is complete, then any symmetry of these constraints is also complete.

Observation 1. Given a set of symmetries Σ of C, if S *is a* sound (complete) set of symmetry breaking constraints for Σ then σ(S) for any σ ∈ Σ *is also a sound (complete) set of* symmetry breaking constraints for Σ. Proof: (Soundness) Consider s ∈ sol(C ∪ S). Then s ∈ sol(C) and s ∈ sol(S). Hence σ(s) ∈ sol(C).

Since s ∈ sol(S), it follows that σ(s) ∈ sol(σ(S)). Thus, σ(s) ∈ sol(C ∪ σ(S)). Hence, there is at least one solution, σ(s) in every symmetry class of C ∪ σ(S). That is, σ(S) is a sound set of symmetry breaking constraints for Σ.

(Completeness) Consider s ∈ sol(C ∪ σ(S)). By a similar argument to soundness, σ
−1(s) ∈ sol(C ∪ S). Hence, there is at most one solution in every symmetry class of C ∪ σ(S).

That is, σ(S) is a complete set of symmetry breaking constraints for Σ. ✷
Different symmetries of the symmetry breaking constraints pick out different solutions in each symmetry class. Thus, if the branching heuristic is going towards a particular solution, there is a symmetry of the symmetry breaking constraints which does not conflict with this.

Observation 2. Given a symmetry group Σ*, a sound set* S
of symmetry breaking constraints for Σ*, and any complete* assignment A, then there exists a symmetry σ in Σ *such that* A *satisfies* σ(S).

Proof: Since the set of symmetry breaking constraints S is sound, it leaves at least one solution (call it B) in the same symmetry class as A. That is, B satisfies S. Since A and B are in the same symmetry class, there exists a symmetry σ in Σ with σ(A) = B. Σ forms a group so also contains the inverse symmetry σ
−1. Since B satisfies S and σ(A) = B,
it follows that σ(A) satisfies S. Hence σ
−1(σ(A)) satisfies σ
−1(S). That is, A satisfies σ
−1(S). ✷

## 4 Model Restarts

We start with a simple application of these observations.

To tackle conflict between branching heuristics and symmetry breaking constraints, Heller *et al.* propose using model restarts [10]. In this method, backtracking search is restarted periodically, using a new model which contains different symmetry breaking constraints. By posting different symmetry breaking constraints, we hope at some point for the branching heuristic and symmetry breaking not to conflict.

Our observations that any symmetry acting on a set of symmetry breaking constraints can be used to break symmetry, and that different symmetries pick out different solutions, provide us with precisely the tools we need to perform model restarts to any domain (and not just to interchangeable variables and values as in [10]). When we restart search, we simply post a different symmetry of the symmetry breaking constraints. We experimented with several possibilities. The simplest is to choose a symmetry at random from the symmetry group. We also tried various heuristics like using the symmetry most consistent or most inconsistent with previous choices of the branching heuristic. However, we observed the best performance of model restarts with a random choice of symmetry so we only report results here with such a choice. Running Example. *Consider again the all interval series* problem and posting symmetries of the symmetry breaking constraints (1), (2) and (3). The following table gives the amount of search needed to find an all interval series of size n = 11 *using a branching heuristic that branches in order* on the variables introduced to represent neighbouring differences in the series, trying values in numerical order. This would seem to be a good branching heuristic since it can find a solution without backtracking.

Symmetry posted Branches Time to solve/s of (1) to (3)
σid 1 0.00 σrev 222,758 13.74 θinv 425,765 24.99 θinv ◦ σrev 170,425 10.23 It is clear from this table that the different symmetries of the symmetry breaking constraints interact differently with the branching heuristic. In particular, the identity symmetry does not conflict in any way as the branching heuristic goes directly to the following solution at the end of the first branch:

## X1, X2**, . . . , X**11 = 0, 10, 1, 9, 2, 8, 3, 7, 4, 6, 5

This solution is consistent with σid *of (1), (2) and (3).*
The other symmetries of the symmetry breaking constraint conflict with the branching heuristic. In particular, the following symmetry breaking constraints conflict with this solution: σrev *of (1) as* X11 = 5 > X1 = 0, θinv *of (1) as* 10 − X1 = 10 > 10 − X11 = 5 and θinv ◦ σrev *of (3) as* 10 − X11 = 5 > X1 = 0*. As a result, posting these symmetries of the symmetry breaking constraints increases the* search needed to find a solution.

Model restarts will help overcome this conflict. Suppose we restart search every 100 branches and choose to post a random symmetry of (1), (2) and (3). Let t *be the average* number of branches to find a solution. There is 14 chance that the first restart will post σid of (1), (2) and (3). In this situation, we find a solution after 1 branch. Otherwise we post one of the other symmetries of (1), (2) and (3). We then explore 100 branches, reach the cutoff and fail to find a solution. As each restart is independent, we restart and explore on average another t *more branches. Hence:*

$$\begin{array}{r c l}{{t}}&{{=}}&{{\frac{1}{4}1+\frac{3}{4}(100+t)}}\end{array}$$

Solving for t *gives* t = 301*. Thus, using model restarts with* a random symmetry of the symmetry breaking constraints, we take just 301 branches on average to find an all interval series of size n = 11. ♣
Note that posting random symmetries of the symmetry breaking constraints is not equivalent to fixing the symmetry