Proof: (Soundness) Immediate as a proper set is sound.

(Completeness) Consider the first solution visited. As the set of symmetry breaking constraints is proper, only one symmetry of these constraints will be entailed. All other symmetries are inconsistent with the current state and are eliminated.

The forced symmetry rule therefore post this symmetry of the symmetry breaking constraints. By Observation 1, as the symmetry breaking constraints are complete, this eliminates all other solutions in the same symmetry class. ✷
Finally, we observe that with certain symmetry breaking constraints, the forced symmetry rule is equivalent to posting symmetry breaking constraints as soon as they are entailed.

For symmetry breaking constraints like X1 < X11, as soon as the constraint or its negation is entailed, all variable symmetries are either consistent or they are eliminated.

6 Interchangeable variables and values
To test these two symmetry breaking methods, we consider
a common type of symmetry where variables and values partition into interchangeable sets [13; 14]. This is sometimes
called piecewise variable and value symmetry. We chose this
class of symmetry other the many other types of symmetry
studied in the past as it was used in the previous experimental study of model restarts [10]. Suppose that the n variables
partition into a disjoint sets and variables within each set are
interchangeable. Similarly, suppose that the m values partition into b disjoint sets and values within each set are interchangeable. We will order variable indices so that Xp(i)to
Xp(i+1)−1 is the ith partition of variables for 1 ≤ i ≤ a, and value indices so that dq(j)to dq(j+1)−1 is the jth partition of
values for 1 ≤ j ≤ b.
Flener *et al.* [14] proved that we can eliminate the exponential number of symmetries due to such interchangeability
with a polynomial number of symmetry breaking constraints:
$$X_{p(i)}\leq\ldots\leq X_{p(i+1)-1}$$  $$\mbox{Gcc}([X_{p(i)},\ldots,X_{p(i+1)-1}],[d_{1},\ldots,d_{m}],[O^{i}_{1},\ldots,O^{i}_{m}])$$  $$(O^{1}_{q(j)},\ldots,O^{a}_{q(j)})\geq_{\mbox{lex}}\ldots\geq_{\mbox{lex}}(O^{1}_{q(j+1)-1},\ldots,O^{a}_{q(j+1)-1})$$
)
Where i ∈ [1, a] and j ∈ [1, b], and GCC counts the number
of occurrences of the values in each equivalence class of variables. That is, Oij = |{k|Xk = dj , p(i) ≤ **k < p**(i + 1)}|.
The *signature* of dk is (O1k
, . . . , Oa
k
), the number of occurrences of dk in each variable partition. The signature is invariant to the permutation of variables within each equivalence class. By ordering variables within each equivalence
class, we prevent permutation of interchangeable variables.
Similarly, by ordering the signatures, we prevent permutation
of interchangeable values.
We will post symmetries of these symmetry breaking constraints. We consider symmetries that act along two degrees
of freedom: the order of interchangeable variables within a
variable partition, and the order of the signatures of interchangeable values within a value partition. Let σ be some
permutation of the indices of interchangeable variables. Then
we can break the symmetry of variable interchangeability
with the following symmetry of the variable ordering constraints:
$X_{\sigma(p(i))}=\cdot\cdot\cdot\cdot\leq X_{\sigma(p(i+1)-1)}$
Similarly let θ be some permutation of the indices of interchangeable values. Then we can break the symmetry of value interchangeability with this symmetry of the signature ordering constraints:
(O1 θ(q(j))**, . . . , O**a θ(q(j))) ≥lex . . . ≥lex (O1 θ(q(j+1)−1)**, . . .**)

## 7 Experiments

We used model restarts and the forced symmetry rule to post symmetries dynamically of the symmetry breaking constraints of Flener *et al.* [14]. Problems are coded into Gecode 2.2.0. We evaluated the two methods on the same two benchmark domains used in previous studies of symmetry breaking for interchangeable variables and values [15]. Experiments were run on an 2-way Intel Xeon with 6MB of cache and 4 cores in each processor running at 2GHz. All instances were terminated after 10 minutes. We used smallest domain as a variable ordering heuristic in each experiment.

For value ordering heuristic, we used lexicographical, antilexicographical and random orderings.

Our experiments are designed to test two hypotheses. The first hypothesis is that these two methods are less prone to conflict between branching heuristics and symmetry breaking. The second hypothesis is that these two methods explore a smaller search tree than dynamic methods like SBDS. This is due to both the propagation of the posted symmetry breaking constraints and the need to limit SBDS to just generators to make it computationally tractable. We limit our comparison of dynamic methods to comparison against SBDS. Whilst there is a specialized dynamic symmetry breaking method for interchangeable variables and values, experiments in [10]
show that this is several orders of magnitude slower than static methods. In addition, dominance detection methods like SBDD are shown to be three orders of magnitude slower than static methods in [10]. Finally, we used SBDS to break just generators of the symmetry group as breaking the full symmetry group quickly ran out of memory. We used SBDS
with two different sets of generators: one set has a generator that exchanges each pair of consecutive variables/values in each partition; the other has a generator that exchanges the first two variables/values in each partition and one that rotate all variables/values. We got similar results with both and thus here report only results for the first set, denoted SBDS-pair in Table 1.

The first set of experiments uses random graph coloring problems generated in the same way as the previous experimental study in [15]. There is a variable for each vertex and not-equals constraints between variables corresponding to connected vertices. All values in this model are interchangeable. In addition, we introduce variable symmetry by partitioning variables into interchangeable sets of size at most 8. We randomly connect the vertices within each partition with either a complete graph or an empty graph, and choose each option with equal probability. Similarly, between any two partitions there is equal probability that the partitions are completely connected or independent. Results for graphs with 40 vertices are shown in the top half of Table 1.

The second set of experiments uses a more structured benchmark which is again taken from a previous experimen-