tal study [15]. In the concert hall scheduling problem, we have n applications to use one of m identical concert halls.

Each application has a start and end time as well as an offer for the hall. We accept applications so that their intervals do not overlap and the profit (the sum of the offers of accepted applications) is maximized. We randomly generate instances so that applications are split into partitions of size at most 8 and within each partition all applications have the same start and end time and offer. Our model assigns Xi = j if the i th application is accepted and placed in hall j, and Xi = m + 1 if it is rejected. Variables corresponding to applicationsin the same partition are interchangeable. Values divide into two partitions: the values 1 to m are interchangeable, while the value m + 1 is in a separate partition. Results for instances with 40 applications and 10 halls are shown in the bottom half of Table 1.

The results support both our hypotheses. Both methods are less prone to conflict between symmetry breaking and the branching heuristic. With both SBDS and our forced symmetry rule for dynamically posting symmetry breaking constraints, we obtained the same results with the lexicographical and the (inverse) anti-lexicographical value ordering heuristic. With model restarts, results with the lexicographical and the anti-lexicographical value ordering heuristic are sufficiently similar that we only report the former. Our second hypothesis, that the two methods explore a smaller search tree than SBDS is also confirmed. SBDS was unable to prove optimality in all but one instance. In addition, on the harder graph coloring instances, both methods tend to outperform the static method. It is hard, however, to choose between the two methods. The model restarts method offers slightly better performance on the graph coloring instances, whilst our method of dynamically posting static symmetry breaking constraints offers better performance on the concert hall scheduling instances.

## 8 Other Related Work

Closest in spirit to our forced symmetry rule for dynamically posting symmetry breaking constraints is SBDS [16; 17; 18]. SBDS can work with any type of branching decision but for simplicity we assume that branching decisions are of the form V ar = val. All current implementations of SBDS
make this assumption. If we have a symmetry σ, the partial assignment A and have explored and rejected V ar = val then on backtracking, SBDS posts:

## Σ(A) → Σ(V Ar 6= Val)

This ensures that we never explore the symmetric state to the one that has just been excluded. Our forced symmetry rule also posts static symmetry breaking dynamically during search. However, the two methods differ along three important dimensions. First, SBDS posts symmetry breaking constraints when backtracking and exploring the second branch of the search tree; the forced symmetry rule, on the other hand, can post symmetry breaking constraints down either branch. Second, SBDS posts symmetries of the current nogood; the forced symmetry rule, on the other hand, can post any type of symmetry breaking constraint. Here, for instance, it posts ordering constraints on the signatures. Third, whilst neither method conflicts with the branching heuristic if the branching heuristic goes directly to a solution, the forced symmetry rule may conflict with the branching heuristic later in search. Constraint propagation on constraints posted by the forced symmetry rule can prune values that branching might have taken.

There are a number of other related methods. Jefferson et al, have proposed GAPLex, a hybrid method that also combines together static and dynamic symmetry breaking
[19]. However, GAPLex is limited to dynamically posting lexicographical ordering constraints, and to searching with a fixed variable ordering. As a consequence, GAPLex performs poorly when there are large numbers of symmetries. In addition, GAPLex is unable to profit from effective dynamic variable ordering heuristics. Puget has also proposed "Dynamic Lex", a hybrid method that dynamically posts static symmetry breaking constraints during search which works with dynamic variable ordering heuristics [20]. This method adds lexicographical ordering symmetry breaking constraints dynamically during search that are compatible with the current partial assignment. In this way, the first solution found during tree search is not pruned by symmetry breaking. Unfortunately Dynamic Lex needs to compute the stabilizers of the current partial assignment. This requires a potentially expensive graph isomorphism problem to be solved at each node of the search tree. Whilst Dynamic Lex works with dynamic variable ordering heuristics, it assumes that values are tried in order. Finally Dynamic Lex is limited to posting lexicographical ordering constraints. This is problematic when there are many symmetries. A direct comparison of our methods with Dynamic Lex would be interesting but poses some challenges. For instance, Heller *et al.* [10] do not compare model restarts with Dynamic Lex, arguing:
"It is not clear how this method [Dynamic Lex] can be generalized, though, and for the case of piecewise variable and value symmetry, no method with similar properties is known yet."

## 9 Conclusions

We proved that any symmetry acting on a set of symmetry breaking constraints itself breaks symmetry, and that different symmetries pick out different solutions in each symmetry class. These observations can be used to reduce the conflict between symmetry breaking and branching heuristics. We have studied two methods for breaking symmetry that tackle this conflict. The first method uses *model restarts* which was proposed in [10]. We periodically restart search with a new model which contains a random symmetry of the symmetry breaking constraints. The second method posts a symmetry of the symmetry breaking constraint dynamically during search.

The symmetry is incrementally chosen to be consistent with the branching heuristic. The two methods benefit from propagation of the posted symmetry breaking constraints, whilst reducing the conflict between symmetry breaking and branching heuristics. Experimental results demonstrated that the two methods perform well on some standard benchmarks.