terminates when sol = nil. This happens only when the search fails to find a solution of the current problem with a preference strictly greater than the current lower bound.

Let us denote with Qiand Qi+1 respectively the IFCSPs given in input to the i-th and i+1-th recursive call of BBE. First we notice that only procedure Elicit@**tree** modifies the IFCSP in input by possibly adding new elicited preferences. Moreover, whatever the value of parameter What is, the returned IFCSP is either the same as the one in input or it is a (possibly partial) completion of the one in input. Thus we have Qi+1 ∈ P C(Qi) and Qi ∈ P C(P). Since the search is always performed on the 1-completion of the current IFCSP, we can conclude that for every solution s, pref(Qi+1, s) ≤ pref(Qi, s). Let us now denote with lbiand lbi+1 the lower bounds given in input respectively to the i-th and i+ 1-th recursive call of BBE. It is easy to see that lbi+1 ≥ lbi. Thus, since at every iteration we have that the preferences of solutions can only get lower, and the bound can only get higher, and since we have a finite number of solutions, we can conclude that BBE always terminates.

The reasoning that follows relies on the fact that value **pref** returned by function Elicit@**tree** is the final preference after elicitation of assignment sol given in input.

This is true since either What = all and thus all preferences have been elicited and the overall preference of sol can be computed or only the worst preference has been elicited but in a fuzzy context where the overall preference coincide with the worst one. If called with When = tree IFCSP-SCHEME exits when the last branch and bound search has ended returning sol = nil. In such a case sol and **pref** are updated to contain the best solution and associated preference found so far, i.e., sol′and **pref**′. Then, the algorithm returns the current IFCSP, say Q, and sol and **pref**. Following the same reasoning as above done for Qi we can conclude that Q ∈ P C(P).

At the end of every while loop execution, assignment sol either contains an optimal solution sol of the 1-completion of the current IFCSP or sol = nil. sol = nil iff there is no assignment with preference higher than lb in the 1-completion of the current IFCSP. In this situation, sol′and **pref**′are an optimal solution and preference of the 1-completion of the current IFCSP. However, since the preference of sol′, **pref**′is independent of unknown preferences and since due to monotonicity the optimal preference value of the 1-completion is always greater than or equal to that of the 0-completion we have that sol′and **pref**′are an optimal solution and preference of the 0-completion of the current IFCSP as well.

By Theorems 1 and 2 of [7] we can conclude that NOS(Q) is not empty. If **pref** =
0, then NOS(Q) contains all the assignments and thus also sol. The algorithm correctly returns the same IFCSP given in input, assignment sol and its preference **pref**.

If instead 0 **< pref**, again the algorithm is correct, since by Theorem 1 of [7] we know that NOS(Q) = Opt(Q0), and we have shown that sol ∈ Opt(Q0).

Case 2: When=branch or node.

In order to prove that the algorithm terminates, it is sufficient to show that BBE terminates. Since the domains are finite, the labeling phase produces a number of finite choices at every level of the search tree. Moreover, since the number of variables is limited, then, we have also a finite number of levels in the tree. Hence, BBE considers at most all the possible assignments, that are a finite number. At the end of the exe-