# Flow-Based Propagators For The Sequence And Related Global Constraints⋆

Michael Maher1, Nina Narodytska1, Claude-Guy Quimper2, and Toby Walsh1 1 NICTA and UNSW, Sydney, Australia 2 Ecole Polytechnique de Montreal, Montreal, Canada Abstract. We propose new filtering algorithms for the SEQUENCE constraint and some extensions of the SEQUENCE constraint based on network flows. We enforce domain consistency on the SEQUENCE constraint in O(n 2
) time down a branch of the search tree. This improves upon the best existing domain consistency algorithm by a factor of O(log n). The flows used in these algorithms are derived from a linear program. Some of them differ from the flows used to propagate global constraints like GCC since the domains of the variables are encoded as costs on the edges rather than capacities. Such flows are efficient for maintaining bounds consistency over large domains and may be useful for other global constraints.

## 1 Introduction

Graph based algorithms play a very important role in constraint programming, especially within propagators for global constraints. For example, Regin's propagator for the ALLDIFFERENT constraint is based on a perfect matching algorithm [1], whilst his propagator for the GCC constraint is based on a network flow algorithm [2]. Both these graph algorithms are derived from the bipartite value graph, in which nodes represent variables and values, and edges represent domains. For example, the GCC propagator finds a flow in such a graph in which each unit of flow represents the assignment of a particular value to a variable. In this paper, we identify a new way to build graph based propagators for global constraints: we convert the global constraint into a linear program and then convert this into a network flow. These encodings contain several novelties. For example, variables domain bounds can be encoded as costs along the edges.

We apply this approach to the SEQUENCE family of constraints. Our results widen the class of global constraints which can be propagated using flow-based algorithms. We conjecture that these methods will be useful to propagate other global constraints.

## 2 Background

A constraint satisfaction problem (CSP) consists of a set of variables, each with a finite domain of values, and a set of constraints specifying allowed combinations of values
⋆ NICTA is funded by the Australian Government as represented by the Department of Broadband, Communications and the Digital Economy and the Australian Research Council.

arXiv:0909.4452v1 [cs.AI] 24 Sep 2009