on the variables, which are not expressed in the matrix, are represented as bounds on the capacity of the corresponding edges.

The graph for the set of equations in the example is given in Figure 1. A flow of value 4u − 3l in the graph corresponds to a solution. If a feasible flow sends a unit flow through the edge labeled with Xithen Xi = 1 in the solution; otherwise Xi = 0. Each even numbered vertex 2i represents a window. The way the incoming flow is shared between yj and zj reflects how many variables Xiin the j'th window are equal to 1. Odd numbered vertices represent transitions from one window to the next (except for the first and last vertices, which represent transitions between a window and nothing). An incoming X edge represents the variable omitted in the transition to the next window, while an outgoing X edge represents the added variable.

![0_image_0.png](0_image_0.png)

Theorem 1. *For any constraint* SEQUENCE(l, u, k, [X1, . . . , Xn], v)*, there is an equivalent network flow graph* G = (**V, E**) *with* 5n − 4k + 5 *edges,* 2n − 2k **+ 3 + 2**
vertices, a maximum edge capacity of u*, and an amount of flow to send equal to* f = (n − k)(u − l) + u. There is a one-to-one correspondence between solutions of the constraint and feasible flows in the network.

The time complexity of finding a maximum flow of value f is O(|E|f) using the Ford-Fulkerson algorithm [12]. Faster algorithms exist for this problem. For example, Goldberg and Rao's algorithm finds a maximum flow in O(min(|V | 2/3, |E| 1/2)|E| **log(**|V | 2/|E| **+ 2) log** C) time where C is the maximum capacity upper bound for an edge [13]. In our case, this gives O(n 3/2log n log u) time complexity. We follow R´egin [1, 2] in the building of an incremental filtering algorithm from the network flow formulation. A feasible flow in the graph gives us a support for one value in each variable domain. Suppose Xk = v is in the solution that corresponds to the feasible flow where v is either zero or one. To obtain a support for Xk = 1 − v, we find the SCC of the residual graph and check if both ends of the edge labeled with