Xk are in the same strongly connected component. If so, Xk = 1−v has a support; otherwise 1 − v can be removed from the domain of Xk. Strongly connected components can be found in linear time, because the number of nodes and edges in the flow network for the SEQUENCE constraint is linear in n by Theorem 1. The total time complexity for initially enforcing DC is O(n((n − k)(u − l) + u)) if we use the Ford-Fulkerson algorithm or O(n 3/2log n log u) if we use Goldberg and Rao's algorithm.

Still following R´egin [1, 2], one can make the algorithm incremental. Suppose during search Xiis fixed to value v. If the last computed flow was a support for Xi = v, then there is no need to recompute the flow. We simply need to recompute the SCC in the new residual graph and enforce DC in O(n) time. If the last computed flow is not a support for Xi = v, we can find a cycle in the residual graph containing the edge associated to Xiin O(n) time. By pushing a unit of flow over this cycle, we obtain a flow that is a support for Xi = v. Enforcing DC can be done in O(n) after computing the SCC. Consequently, there is an incremental cost of O(n) when a variable is fixed, and the cost of enforcing DC down a branch of the search tree is O(n 2).

## 5 Soft Sequence Constraint

Soft forms of the SEQUENCE constraint may be useful in practice. The ROADEF 2005 challenge [14], which was proposed and sponsored by Renault, puts forward a violation measure for the SEQUENCE constraint which takes into account by how much each AMONG constraint is violated. We therefore consider the soft global constraint, SOFTSEQUENCE(l, u, k, T, [X1, . . . , Xn], v). This holds iff:

$$T\geq\sum_{i=1}^{n-k+1}\max(l-\sum_{j=0}^{k-1}(X_{i+j}\in v),\sum_{j=0}^{k-1}(X_{i+j}\in v)-u,0)\tag{1}$$

As before, we can simplify notation and consider SOFTSEQUENCE on 0/1 variables and v = {1}.

We again convert to a flow problem by means of a linear program, but this time with an objective function. Consider SOFTSEQUENCE(l, u, 3, T, [X1, . . . , X6], v). We introduce variables, Qi and Pito represent the penalties that may arise from violating lower and upper bounds respectively. We can then express this SOFTSEQUENCE constraint as follows. The objective function gives a lower bound on T .

MinimizeX 4 i=1 (Pi + Qi) subject to : X1 + X2 + X3 − Y1 + Q1 = l, X1 + X2 + X3 + Z1 − P1 = u, X2 + X3 + X4 − Y2 + Q2 = l, X2 + X3 + X4 + Z2 − P2 = u, X3 + X4 + X5 − Y3 + Q3 = l, X3 + X4 + X5 + Z3 − P3 = u, X4 + X5 + X6 − Y4 + Q4 = l, X4 + X5 + X6 + Z3 − P4 = u
where Yi, Zi, Pi and Qi are non-negative. In matrix form, this is: